/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent.proc;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;

public class AffineInvariantMoments
implements ConnectedComponentProcessor,
FeatureVectorProvider<DoubleFV> {
    public double I1;
    public double I2;
    public double I3;
    public double I4;

    public void process(ConnectedComponent cc) {
        double u00 = cc.calculateMoment(0, 0);
        double u20 = cc.calculateMoment(2, 0);
        double u02 = cc.calculateMoment(0, 2);
        double u11 = cc.calculateMoment(1, 1);
        double u21 = cc.calculateMoment(2, 1);
        double u12 = cc.calculateMoment(1, 2);
        double u30 = cc.calculateMoment(3, 0);
        double u03 = cc.calculateMoment(0, 3);
        this.I1 = (u20 * u02 - u11 * u11) / Math.pow(u00, 4.0);
        this.I2 = (u30 * u30 * u03 * u03 - 6.0 * u30 * u21 * u12 * u03 + 4.0 * u30 * Math.pow(u12, 3.0) + 4.0 * Math.pow(u21, 3.0) * u03 - 3.0 * u21 * u21 * u12 * u12) / Math.pow(u00, 10.0);
        this.I3 = (u20 * (u21 * u03 - u12 * u12) - u11 * (u30 * u03 - u21 * u12) + u02 * (u30 * u12 - u21 * u21)) / Math.pow(u00, 7.0);
        this.I4 = (Math.pow(u20, 3.0) * u03 * u03 - 6.0 * u20 * u20 * u11 * u12 * u03 - 6.0 * u20 * u20 * u02 * u21 * u03 + 9.0 * u20 * u20 * u02 * u12 * u12 + 12.0 * u20 * u11 * u11 * u21 * u03 + 6.0 * u21 * u11 * u02 * u30 * u03 - 18.0 * u20 * u11 * u02 * u21 * u12 - 8.0 * Math.pow(u11, 3.0) * u30 * u03 - 6.0 * u20 * u02 * u02 * u30 * u12 + 9.0 * u20 * u02 * u02 * u21 * u21 + 12.0 * u11 * u11 * u02 * u30 * u12 - 6.0 * u11 * u02 * u02 * u30 * u21 + Math.pow(u02, 3.0) * u30 * u30) / Math.pow(u00, 11.0);
    }

    public String toString() {
        return String.format("%2.2f, %2.2f, %2.2f, %2.2f", this.I1, this.I2, this.I3, this.I4);
    }

    public double[] getFeatureVectorArray() {
        return new double[]{this.I1, this.I2, this.I3, this.I4};
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(this.getFeatureVectorArray());
    }
}

