/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class TwitterPhotoConsumer
implements SiteSpecificConsumer {
    @Override
    public boolean canConsume(URL url) {
        if (url.getHost().equals("twitter.com") && url.getPath().contains("photo")) {
            return true;
        }
        return url.getHost().endsWith("twimg.com") && url.getPath().contains("media");
    }

    @Override
    public List<URL> consume(URL url) {
        if (url.getHost().endsWith("twimg.com")) {
            return Arrays.asList(url);
        }
        String largeURLStr = url.toString();
        if (!largeURLStr.endsWith("large")) {
            largeURLStr = largeURLStr + "/large";
        }
        try {
            Document doc = Jsoup.connect((String)largeURLStr).get();
            Elements largeimage = doc.select(".media-slideshow-image");
            URL link = new URL(largeimage.get(0).attr("src"));
            return Arrays.asList(link);
        }
        catch (Exception e) {
            return null;
        }
    }
}

