/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.scraping.images;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class ImgurClient {
    private static final Pattern hashPattern = Pattern.compile("(^[a-zA-Z0-9]+)");
    private String apiKey;
    private DefaultHttpClient client;
    private static String ENDPOINT = "http://api.imgur.com/2";
    private transient Gson gson = new Gson();
    private static Logger logger = Logger.getLogger(ImgurClient.class);

    public ImgurClient() {
        this.apiKey = System.getProperty("imgur.api_key");
        if (this.apiKey == null) {
            this.apiKey = "fecf663ef507f598e8119451e17a6c29";
        }
        this.client = new DefaultHttpClient();
    }

    public List<ImageResponse> getImages(ImgurTypeHash typehash) throws ClientProtocolException, IOException {
        ArrayList<ImageResponse> ret = new ArrayList<ImageResponse>();
        switch (typehash.type) {
            case IMAGE: {
                ret.add(this.getSingleImage(typehash.hash));
                break;
            }
            case ALBUM: {
                ret.addAll(this.getAlbumImages(typehash.hash));
                break;
            }
            case GALLERY: {
                ret.addAll(this.getGalleryImages());
            }
        }
        return ret;
    }

    public ImageResponse getSingleImage(String hash) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(String.format("%s/image/%s.json", ENDPOINT, hash));
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        ImgurResponse resp = (ImgurResponse)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent()), ImgurResponse.class);
        return resp.image;
    }

    public List<ImageResponse> getAlbumImages(String hash) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(String.format("%s/album/%s.json", ENDPOINT, hash));
        HttpResponse response = this.client.execute((HttpUriRequest)get);
        ImgurResponse resp = (ImgurResponse)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent()), ImgurResponse.class);
        return resp.album.images;
    }

    public List<ImageResponse> getGalleryImages() {
        return null;
    }

    public static ImgurTypeHash imgurURLtoHash(URL url) {
        if (!url.getHost().contains("imgur")) {
            return null;
        }
        String path = url.getPath();
        String[] split = path.split("[/]+");
        if (split.length == 0) {
            return null;
        }
        if (split.length == 2) {
            if (split[1].equals("gallery")) {
                return new ImgurTypeHash(ImgurType.GALLERY, null);
            }
            Matcher matcher = hashPattern.matcher(split[1]);
            if (matcher.find()) {
                String hash = split[1].substring(0, matcher.end());
                return new ImgurTypeHash(ImgurType.IMAGE, hash);
            }
            return null;
        }
        String hashPart = split[split.length - 1];
        String typePart = split[split.length - 2];
        ImgurType type = ImgurType.IMAGE;
        if (typePart.equals("a")) {
            type = ImgurType.ALBUM;
        }
        Matcher matcher = hashPattern.matcher(hashPart);
        matcher.find();
        String hash = hashPart.substring(0, matcher.end());
        return new ImgurTypeHash(type, hash);
    }

    public static class ImageResponse {
        public Map<String, Object> image;
        public Map<String, Object> links;

        public URL getOriginalLink() {
            String orig = (String)this.links.get("original");
            if (orig == null) {
                return null;
            }
            try {
                return new URL(orig);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    private static class AlbumImgurResponse {
        List<ImageResponse> images;

        private AlbumImgurResponse() {
        }
    }

    private static class ImgurResponse {
        AlbumImgurResponse album;
        ImageResponse image;

        private ImgurResponse() {
        }
    }

    public static class ImgurTypeHash {
        public ImgurType type;
        public String hash;

        protected ImgurTypeHash(ImgurType type, String hash) {
            this.hash = hash;
            this.type = type;
        }

        public String toString() {
            return String.format("Imgur [%s] %s", new Object[]{this.type, this.hash});
        }
    }

    public static enum ImgurType {
        ALBUM,
        IMAGE,
        GALLERY;

    }
}

