/*
 * Decompiled with CFR 0.152.
 */
package com.bethecoder.ascii_table.impl;

import com.bethecoder.ascii_table.ASCIITableHeader;
import com.bethecoder.ascii_table.spec.IASCIITable;
import com.bethecoder.ascii_table.spec.IASCIITableAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SimpleASCIITableImpl
implements IASCIITable {
    @Override
    public void printTable(String[] header, String[][] data) {
        this.printTable(header, 0, data, 1);
    }

    @Override
    public void printTable(String[] header, String[][] data, int dataAlign) {
        this.printTable(header, 0, data, dataAlign);
    }

    @Override
    public void printTable(String[] header, int headerAlign, String[][] data, int dataAlign) {
        System.out.println(this.getTable(header, headerAlign, data, dataAlign));
    }

    @Override
    public String getTable(String[] header, String[][] data) {
        return this.getTable(header, 0, data, 1);
    }

    @Override
    public String getTable(String[] header, String[][] data, int dataAlign) {
        return this.getTable(header, 0, data, dataAlign);
    }

    @Override
    public String getTable(String[] header, int headerAlign, String[][] data, int dataAlign) {
        ASCIITableHeader[] headerObjs = new ASCIITableHeader[]{};
        if (header != null && header.length > 0) {
            headerObjs = new ASCIITableHeader[header.length];
            int i = 0;
            while (i < header.length) {
                headerObjs[i] = new ASCIITableHeader(header[i], dataAlign, headerAlign);
                ++i;
            }
        }
        return this.getTable(headerObjs, data);
    }

    @Override
    public void printTable(ASCIITableHeader[] headerObjs, String[][] data) {
        System.out.println(this.getTable(headerObjs, data));
    }

    @Override
    public String getTable(IASCIITableAware asciiTableAware) {
        ASCIITableHeader[] headerObjs = new ASCIITableHeader[]{};
        String[][] data = new String[0][0];
        List<Object> rowData = null;
        ASCIITableHeader colHeader = null;
        Vector<String> rowTransData = null;
        Object[] rowContent = null;
        String cellData = null;
        if (asciiTableAware != null) {
            int i;
            if (asciiTableAware.getHeaders() != null && !asciiTableAware.getHeaders().isEmpty()) {
                headerObjs = new ASCIITableHeader[asciiTableAware.getHeaders().size()];
                i = 0;
                while (i < asciiTableAware.getHeaders().size()) {
                    headerObjs[i] = asciiTableAware.getHeaders().get(i);
                    ++i;
                }
            }
            if (asciiTableAware.getData() != null && !asciiTableAware.getData().isEmpty()) {
                data = new String[asciiTableAware.getData().size()][];
                i = 0;
                while (i < asciiTableAware.getData().size()) {
                    rowData = asciiTableAware.getData().get(i);
                    rowTransData = new Vector<String>(rowData.size());
                    int j = 0;
                    while (j < rowData.size()) {
                        colHeader = j < headerObjs.length ? headerObjs[j] : null;
                        cellData = asciiTableAware.formatData(colHeader, i, j, rowData.get(j));
                        if (cellData == null) {
                            cellData = String.valueOf(rowData.get(j));
                        }
                        rowTransData.add(cellData);
                        ++j;
                    }
                    rowContent = new String[rowTransData.size()];
                    rowTransData.copyInto(rowContent);
                    data[i] = rowContent;
                    ++i;
                }
            }
        }
        return this.getTable(headerObjs, data);
    }

    @Override
    public void printTable(IASCIITableAware asciiTableAware) {
        System.out.println(this.getTable(asciiTableAware));
    }

    @Override
    public String getTable(ASCIITableHeader[] headerObjs, String[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Please provide valid data : " + data);
        }
        StringBuilder tableBuf = new StringBuilder();
        String[] header = this.getHeaders(headerObjs);
        int colCount = this.getMaxColumns(header, data);
        List<Integer> colMaxLenList = this.getMaxColLengths(colCount, header, data);
        if (header != null && header.length > 0) {
            tableBuf.append(this.getRowLineBuf(colCount, colMaxLenList, data));
            tableBuf.append(this.getRowDataBuf(colCount, colMaxLenList, header, headerObjs, true));
        }
        tableBuf.append(this.getRowLineBuf(colCount, colMaxLenList, data));
        String[] rowData = null;
        int i = 0;
        while (i < data.length) {
            rowData = new String[colCount];
            int j = 0;
            while (j < colCount) {
                rowData[j] = j < data[i].length ? data[i][j] : "";
                ++j;
            }
            tableBuf.append(this.getRowDataBuf(colCount, colMaxLenList, rowData, headerObjs, false));
            ++i;
        }
        tableBuf.append(this.getRowLineBuf(colCount, colMaxLenList, data));
        return tableBuf.toString();
    }

    private String getRowDataBuf(int colCount, List<Integer> colMaxLenList, String[] row, ASCIITableHeader[] headerObjs, boolean isHeader) {
        StringBuilder rowBuilder = new StringBuilder();
        String formattedData = null;
        int i = 0;
        while (i < colCount) {
            int align;
            int n = align = isHeader ? 0 : 1;
            if (headerObjs != null && i < headerObjs.length) {
                align = isHeader ? headerObjs[i].getHeaderAlign() : headerObjs[i].getDataAlign();
            }
            formattedData = i < row.length ? row[i] : "";
            formattedData = "| " + this.getFormattedData(colMaxLenList.get(i), formattedData, align) + " ";
            if (i + 1 == colCount) {
                formattedData = String.valueOf(formattedData) + "|";
            }
            rowBuilder.append(formattedData);
            ++i;
        }
        return rowBuilder.append("\n").toString();
    }

    private String getFormattedData(int maxLength, String data, int align) {
        if (data.length() > maxLength) {
            return data;
        }
        boolean toggle = true;
        while (data.length() < maxLength) {
            if (align == -1) {
                data = String.valueOf(data) + " ";
                continue;
            }
            if (align == 1) {
                data = " " + data;
                continue;
            }
            if (align != 0) continue;
            if (toggle) {
                data = " " + data;
                toggle = false;
                continue;
            }
            data = String.valueOf(data) + " ";
            toggle = true;
        }
        return data;
    }

    private String getRowLineBuf(int colCount, List<Integer> colMaxLenList, String[][] data) {
        StringBuilder rowBuilder = new StringBuilder();
        int colWidth = 0;
        int i = 0;
        while (i < colCount) {
            colWidth = colMaxLenList.get(i) + 3;
            int j = 0;
            while (j < colWidth) {
                if (j == 0) {
                    rowBuilder.append("+");
                } else if (i + 1 == colCount && j + 1 == colWidth) {
                    rowBuilder.append("-+");
                } else {
                    rowBuilder.append("-");
                }
                ++j;
            }
            ++i;
        }
        return rowBuilder.append("\n").toString();
    }

    private int getMaxItemLength(List<String> colData) {
        int maxLength = 0;
        int i = 0;
        while (i < colData.size()) {
            maxLength = Math.max(colData.get(i).length(), maxLength);
            ++i;
        }
        return maxLength;
    }

    private int getMaxColumns(String[] header, String[][] data) {
        int maxColumns = 0;
        int i = 0;
        while (i < data.length) {
            maxColumns = Math.max(data[i].length, maxColumns);
            ++i;
        }
        maxColumns = Math.max(header.length, maxColumns);
        return maxColumns;
    }

    private List<Integer> getMaxColLengths(int colCount, String[] header, String[][] data) {
        ArrayList<Integer> colMaxLenList = new ArrayList<Integer>(colCount);
        ArrayList<String> colData = null;
        int i = 0;
        while (i < colCount) {
            colData = new ArrayList<String>();
            if (header != null && i < header.length) {
                colData.add(header[i]);
            }
            int j = 0;
            while (j < data.length) {
                if (i < data[j].length) {
                    colData.add(data[j][i]);
                } else {
                    colData.add("");
                }
                ++j;
            }
            int maxLength = this.getMaxItemLength(colData);
            colMaxLenList.add(maxLength);
            ++i;
        }
        return colMaxLenList;
    }

    private String[] getHeaders(ASCIITableHeader[] headerObjs) {
        String[] header = new String[]{};
        if (headerObjs != null && headerObjs.length > 0) {
            header = new String[headerObjs.length];
            int i = 0;
            while (i < headerObjs.length) {
                header[i] = headerObjs[i].getHeaderName();
                ++i;
            }
        }
        return header;
    }
}

