/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.util.DiskChecker;

public class RoundRobinVolumeChoosingPolicy<V extends FsVolumeSpi>
implements VolumeChoosingPolicy<V> {
    public static final Log LOG = LogFactory.getLog(RoundRobinVolumeChoosingPolicy.class);
    private int[] curVolumes;
    private Object[] syncLocks;

    public RoundRobinVolumeChoosingPolicy() {
        int numStorageTypes = StorageType.values().length;
        this.curVolumes = new int[numStorageTypes];
        this.syncLocks = new Object[numStorageTypes];
        for (int i = 0; i < numStorageTypes; ++i) {
            this.syncLocks[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V chooseVolume(List<V> volumes, long blockSize) throws IOException {
        if (volumes.size() < 1) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        StorageType storageType = ((FsVolumeSpi)volumes.get(0)).getStorageType();
        int index = storageType != null ? storageType.ordinal() : StorageType.DEFAULT.ordinal();
        Object object = this.syncLocks[index];
        synchronized (object) {
            return this.chooseVolume(index, volumes, blockSize);
        }
    }

    private V chooseVolume(int curVolumeIndex, List<V> volumes, long blockSize) throws IOException {
        int curVolume;
        int startVolume = curVolume = this.curVolumes[curVolumeIndex] < volumes.size() ? this.curVolumes[curVolumeIndex] : 0;
        long maxAvailable = 0L;
        do {
            FsVolumeSpi volume = (FsVolumeSpi)volumes.get(curVolume);
            curVolume = (curVolume + 1) % volumes.size();
            long availableVolumeSize = volume.getAvailable();
            if (availableVolumeSize > blockSize) {
                this.curVolumes[curVolumeIndex] = curVolume;
                return (V)volume;
            }
            if (availableVolumeSize <= maxAvailable) continue;
            maxAvailable = availableVolumeSize;
        } while (curVolume != startVolume);
        throw new DiskChecker.DiskOutOfSpaceException("Out of space: The volume with the most available space (=" + maxAvailable + " B) is less than the block size (=" + blockSize + " B).");
    }
}

