/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioFormat;

public class TriangularFilter {
    protected double lowFrequency = 0.0;
    protected double highFrequency = 20000.0;
    protected double centreFrequency = 10000.0;
    protected double filterAmplitude;
    protected double lowSlope;
    protected double highSlope;

    public TriangularFilter(double low, double centre, double high) {
        if (high <= low) {
            throw new IllegalArgumentException("Triangular Filter start and end frequencies are incorrect: " + high + " <= " + low);
        }
        this.lowFrequency = low;
        this.highFrequency = high;
        this.centreFrequency = centre;
        this.filterAmplitude = 2.0 / (this.highFrequency - this.lowFrequency);
        this.lowSlope = this.filterAmplitude / (this.centreFrequency - this.lowFrequency);
        this.highSlope = this.filterAmplitude / (this.highFrequency - this.centreFrequency);
    }

    public double getLowFrequency() {
        return this.lowFrequency;
    }

    public void setLowFrequency(double lowFrequency) {
        this.lowFrequency = lowFrequency;
        if (this.highFrequency <= this.lowFrequency) {
            throw new IllegalArgumentException("Triangular Filter start and end frequencies are incorrect: " + this.highFrequency + " <= " + this.lowFrequency);
        }
    }

    public double getHighFrequency() {
        return this.highFrequency;
    }

    public void setHighFrequency(double highFrequency) {
        this.highFrequency = highFrequency;
        if (this.highFrequency <= this.lowFrequency) {
            throw new IllegalArgumentException("Triangular Filter start and end frequencies are incorrect: " + highFrequency + " <= " + this.lowFrequency);
        }
    }

    public double getCentreFrequency() {
        return this.centreFrequency;
    }

    public void setCentreFrequency(double centreFrequency) {
        this.centreFrequency = centreFrequency;
        if (this.centreFrequency <= this.lowFrequency || this.centreFrequency >= this.highFrequency) {
            throw new IllegalArgumentException("Triangular Filter start and end frequencies are incorrect: centre frequency " + centreFrequency);
        }
    }

    public double process(float[] frequencySpectrum, AudioFormat format) {
        double output = 0.0;
        double binSize = format.getSampleRateKHz() * 1000.0 / (double)(frequencySpectrum.length / 2);
        int startBin = (int)(this.lowFrequency / binSize);
        int endBin = (int)(this.highFrequency / binSize);
        for (int x = startBin; x < endBin; ++x) {
            if (x < 0 || x >= frequencySpectrum.length) continue;
            double binFreq = binSize * (double)x;
            double weight = this.getWeightAt(binFreq);
            output += weight * (double)frequencySpectrum[x];
        }
        return output;
    }

    public double[] getResponseCurve(int nSpectrumBins, double maxFreq) {
        double[] curve = new double[nSpectrumBins];
        double binSize = maxFreq / (double)nSpectrumBins;
        for (int x = 0; x < nSpectrumBins; ++x) {
            curve[x] = this.getWeightAt(binSize * (double)x);
        }
        return curve;
    }

    public double getWeightAt(double frequency) {
        double weight = 0.0;
        weight = frequency < this.centreFrequency ? this.filterAmplitude - this.lowSlope * (this.centreFrequency - frequency) : this.filterAmplitude - this.highSlope * (frequency - this.centreFrequency);
        if (weight < 0.0) {
            weight = 0.0;
        }
        return weight;
    }

    public double getFilterAmplitude() {
        return this.filterAmplitude;
    }

    public void setFilterAmplitude(double fa) {
        this.filterAmplitude = fa;
        this.lowSlope = this.filterAmplitude / (this.centreFrequency - this.lowFrequency);
        this.highSlope = this.filterAmplitude / (this.highFrequency - this.centreFrequency);
    }

    public String toString() {
        return "tf{" + this.lowFrequency + "->" + this.centreFrequency + "->" + this.highFrequency + "}";
    }
}

