/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.filters.WeightedWindowedAudioProcessor;

public class HanningAudioProcessor
extends WeightedWindowedAudioProcessor {
    public HanningAudioProcessor(int sizeRequired) {
        super(sizeRequired);
    }

    public HanningAudioProcessor(AudioStream stream, int sizeRequired) {
        super(stream, sizeRequired);
    }

    public HanningAudioProcessor(int nSamplesInWindow, int nSamplesOverlap) {
        super(nSamplesInWindow, nSamplesOverlap);
    }

    public HanningAudioProcessor(AudioStream as, int nSamplesInWindow, int nSamplesOverlap) {
        super(as, nSamplesInWindow, nSamplesOverlap);
    }

    @Override
    protected void generateWeightTableCache(int length, int nc) {
        int ns = length;
        this.weightTable = new double[length];
        for (int n = 0; n < ns; ++n) {
            for (int c = 0; c < nc; ++c) {
                this.weightTable[n * nc + c] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)n / (double)ns));
            }
        }
    }
}

