/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.conversion;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;

public class BitDepthConverter
extends AudioProcessor {
    private BitDepthConversionAlgorithm bitDepthConverter = BitDepthConversionAlgorithm.NEAREST;
    private AudioFormat outputFormat = null;

    public BitDepthConverter(BitDepthConversionAlgorithm converter, AudioFormat outputFormat) {
        this.bitDepthConverter = converter;
        this.outputFormat = outputFormat;
        this.setFormat(outputFormat);
    }

    public BitDepthConverter(AudioStream as, BitDepthConversionAlgorithm converter, AudioFormat outputFormat) {
        super(as);
        this.bitDepthConverter = converter;
        this.outputFormat = outputFormat;
        this.setFormat(outputFormat);
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        if (sample.getFormat().getSampleRateKHz() != this.outputFormat.getSampleRateKHz()) {
            throw new IllegalArgumentException("The sample rate of the output format is not the same as the sample chunk. Use a sample rate converter first before using the bit depthconverter.");
        }
        if (sample.getFormat().getNumChannels() != this.outputFormat.getNumChannels()) {
            throw new IllegalArgumentException("The number of channels in the output format is not the same as the sample chunk. Use a channel converter first before using the bit-depth converter.");
        }
        if (sample.getFormat().getNBits() == this.outputFormat.getNBits()) {
            return sample;
        }
        SampleChunk sc = this.bitDepthConverter.process(sample, this.outputFormat);
        sc.setStartTimecode(sample.getStartTimecode());
        return sc;
    }

    public static enum BitDepthConversionAlgorithm {
        NEAREST{

            @Override
            public SampleChunk process(SampleChunk s, AudioFormat output) {
                SampleBuffer sbin = s.getSampleBuffer();
                SampleBuffer sbout = SampleBufferFactory.createSampleBuffer((AudioFormat)output, (int)sbin.size());
                sbout.setFormat(output);
                for (int i = 0; i < sbin.size(); ++i) {
                    sbout.set(i, sbin.get(i));
                }
                return sbout.getSampleChunk();
            }
        };


        public abstract SampleChunk process(SampleChunk var1, AudioFormat var2);
    }
}

