/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.List;
import java.util.Set;
import org.openimaj.audio.SampleChunk;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.IdentityFeatureExtractor;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.ml.annotation.basic.KNNAnnotator;
import org.openimaj.ml.annotation.bayes.NaiveBayesAnnotator;
import org.openimaj.util.comparator.DistanceComparator;

public abstract class AudioAnnotator
extends IncrementalAnnotator<DoubleFV, String>
implements FeatureExtractor<DoubleFV, SampleChunk> {
    private AudioAnnotatorType annotator = AudioAnnotatorType.KNN;

    public void train(Annotated<DoubleFV, String> annotated) {
        this.getAnnotator().getAnnotator().train(annotated);
    }

    public void reset() {
        this.getAnnotator().getAnnotator().reset();
    }

    public Set<String> getAnnotations() {
        return this.getAnnotator().getAnnotator().getAnnotations();
    }

    public List<ScoredAnnotation<String>> annotate(DoubleFV object) {
        return this.getAnnotator().getAnnotator().annotate((Object)object);
    }

    public AudioAnnotatorType getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(AudioAnnotatorType annotator) {
        this.annotator = annotator;
    }

    public static enum AudioAnnotatorType {
        KNN{
            private KNNAnnotator<DoubleFV, String, DoubleFV> k;

            @Override
            public IncrementalAnnotator<DoubleFV, String> getAnnotator() {
                if (this.k == null) {
                    this.k = new KNNAnnotator((FeatureExtractor)new IdentityFeatureExtractor(), (DistanceComparator)DoubleFVComparison.EUCLIDEAN);
                }
                return this.k;
            }
        }
        ,
        BAYES{
            private IncrementalAnnotator<DoubleFV, String> n;

            @Override
            public IncrementalAnnotator<DoubleFV, String> getAnnotator() {
                if (this.n == null) {
                    this.n = new NaiveBayesAnnotator((FeatureExtractor)new IdentityFeatureExtractor(), NaiveBayesAnnotator.Mode.ALL);
                }
                return this.n;
            }
        };


        public abstract IncrementalAnnotator<DoubleFV, String> getAnnotator();
    }
}

