/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.Problem;

class L2R_LrFunction
implements Function {
    private final double[] C;
    private final double[] z;
    private final double[] D;
    private final Problem prob;

    public L2R_LrFunction(Problem prob, double[] C) {
        int l = prob.l;
        this.prob = prob;
        this.z = new double[l];
        this.D = new double[l];
        this.C = C;
    }

    private void Xv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.prob.l) {
            Xv[i] = 0.0;
            Feature[] featureArray = this.prob.x[i];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature s = featureArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.getIndex() - 1] * s.getValue();
                ++n2;
            }
            ++i;
        }
    }

    private void XTv(double[] v, double[] XTv) {
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        int i = 0;
        while (i < w_size) {
            XTv[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            Feature[] featureArray = x[i];
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature s = featureArray[n2];
                int n3 = s.getIndex() - 1;
                XTv[n3] = XTv[n3] + v[i] * s.getValue();
                ++n2;
            }
            ++i;
        }
    }

    @Override
    public double fun(double[] w) {
        double f = 0.0;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.Xv(w, this.z);
        int i = 0;
        while (i < w_size) {
            f += w[i] * w[i];
            ++i;
        }
        f /= 2.0;
        i = 0;
        while (i < l) {
            double yz = y[i] * this.z[i];
            f = yz >= 0.0 ? (f += this.C[i] * Math.log(1.0 + Math.exp(-yz))) : (f += this.C[i] * (-yz + Math.log(1.0 + Math.exp(yz))));
            ++i;
        }
        return f;
    }

    @Override
    public void grad(double[] w, double[] g) {
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        int i = 0;
        while (i < l) {
            this.z[i] = 1.0 / (1.0 + Math.exp(-y[i] * this.z[i]));
            this.D[i] = this.z[i] * (1.0 - this.z[i]);
            this.z[i] = this.C[i] * (this.z[i] - 1.0) * y[i];
            ++i;
        }
        this.XTv(this.z, g);
        i = 0;
        while (i < w_size) {
            g[i] = w[i] + g[i];
            ++i;
        }
    }

    @Override
    public void Hv(double[] s, double[] Hs) {
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        double[] wa = new double[l];
        this.Xv(s, wa);
        int i = 0;
        while (i < l) {
            wa[i] = this.C[i] * this.D[i] * wa[i];
            ++i;
        }
        this.XTv(wa, Hs);
        i = 0;
        while (i < w_size) {
            Hs[i] = s[i] + Hs[i];
            ++i;
        }
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }
}

