/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex.citation;

import java.util.Arrays;
import java.util.List;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.Value;
import org.jbibtex.citation.EntryFormat;
import org.jbibtex.citation.FieldFormat;
import org.jbibtex.citation.ReferenceStyle;

public class ACSReferenceStyle
extends ReferenceStyle {
    public ACSReferenceStyle() {
        this.addFormat(BibTeXEntry.TYPE_ARTICLE, ACSReferenceStyle.createArticleFormat());
        this.addFormat(BibTeXEntry.TYPE_BOOK, ACSReferenceStyle.createBookFormat());
        this.addFormat(BibTeXEntry.TYPE_INCOLLECTION, ACSReferenceStyle.createInCollectionFormat());
        this.addFormat(BibTeXEntry.TYPE_INPROCEEDINGS, ACSReferenceStyle.createInProceedingsFormat());
        this.addFormat(BibTeXEntry.TYPE_UNPUBLISHED, ACSReferenceStyle.createUnpublishedFormat());
    }

    private static EntryFormat createArticleFormat() {
        List<FieldFormat> fields = Arrays.asList(new AuthorFormat(null), new FieldFormat(BibTeXEntry.KEY_TITLE, "."), new JournalFormat(null), new FieldFormat(BibTeXEntry.KEY_YEAR, ","), new VolumeFormat(","), new FieldFormat(BibTeXEntry.KEY_NUMBER, ","), new FieldFormat(BibTeXEntry.KEY_PAGES, "."), new DOIFormat(null));
        return new EntryFormat(fields);
    }

    private static EntryFormat createBookFormat() {
        List<FieldFormat> fields = Arrays.asList(new AuthorFormat(null), new BookTitleFormat(";"), new EditorFormat(";"), new FieldFormat(BibTeXEntry.KEY_PUBLISHER, ":"), new FieldFormat(BibTeXEntry.KEY_ADDRESS, ";"), new FieldFormat(BibTeXEntry.KEY_YEAR, "."), new DOIFormat(null));
        return new EntryFormat(fields);
    }

    private static EntryFormat createInCollectionFormat() {
        List<FieldFormat> fields = Arrays.asList(new AuthorFormat(null), new FieldFormat(BibTeXEntry.KEY_TITLE, "."), new InBookTitleFormat(";"), new EditorFormat(";"), new FieldFormat(BibTeXEntry.KEY_PUBLISHER, ";"), new FieldFormat(BibTeXEntry.KEY_YEAR, "."), new DOIFormat(null));
        return new EntryFormat(fields);
    }

    private static EntryFormat createInProceedingsFormat() {
        List<FieldFormat> fields = Arrays.asList(new AuthorFormat(null), new FieldFormat(BibTeXEntry.KEY_TITLE, "."), new InBookTitleFormat(";"), new EditorFormat(";"), new FieldFormat(BibTeXEntry.KEY_ORGANIZATION, ";"), new FieldFormat(BibTeXEntry.KEY_YEAR, "."), new DOIFormat(null));
        return new EntryFormat(fields);
    }

    private static EntryFormat createUnpublishedFormat() {
        List<FieldFormat> fields = Arrays.asList(new AuthorFormat(null), new FieldFormat(BibTeXEntry.KEY_TITLE, "."));
        return new EntryFormat(fields);
    }

    private static String bold(String string, boolean html) {
        if (html) {
            string = "<b>" + string + "</b>";
        }
        return string;
    }

    private static String italic(String string, boolean html) {
        if (html) {
            string = "<i>" + string + "</i>";
        }
        return string;
    }

    private static class VolumeFormat
    extends FieldFormat {
        public VolumeFormat(String separator) {
            super(BibTeXEntry.KEY_VOLUME, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            return ACSReferenceStyle.bold(string, html);
        }
    }

    private static class JournalFormat
    extends FieldFormat {
        public JournalFormat(String separator) {
            super(BibTeXEntry.KEY_JOURNAL, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            return ACSReferenceStyle.italic(string, html);
        }
    }

    private static class InBookTitleFormat
    extends BookTitleFormat {
        public InBookTitleFormat(String separator) {
            super(separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            string = "In " + string;
            return string;
        }
    }

    private static class EditorFormat
    extends FieldFormat {
        public EditorFormat(String separator) {
            super(BibTeXEntry.KEY_EDITOR, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            string = string.replace(" and ", "; ");
            boolean plural = string.contains("; ");
            string = string + ", " + (plural ? "Eds." : "Ed.");
            return string;
        }
    }

    private static class DOIFormat
    extends FieldFormat {
        public DOIFormat(String separator) {
            super(BibTeXEntry.KEY_DOI, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            string = html ? "DOI: <a href=\"http://dx.doi.org/" + string + "\">" + string + "</a>" : "DOI: " + string;
            return string;
        }
    }

    private static class BookTitleFormat
    extends FieldFormat {
        public BookTitleFormat(String separator) {
            super(BibTeXEntry.KEY_BOOKTITLE, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            return ACSReferenceStyle.italic(string, html);
        }
    }

    private static class AuthorFormat
    extends FieldFormat {
        public AuthorFormat(String separator) {
            super(BibTeXEntry.KEY_AUTHOR, separator);
        }

        public String format(Value value, boolean latex, boolean html) {
            String string = super.format(value, latex, html);
            string = string.replace(" and ", "; ");
            return string;
        }
    }
}

