/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbibtex.LaTeXCommand;
import org.jbibtex.LaTeXGroup;
import org.jbibtex.LaTeXObject;
import org.jbibtex.LaTeXString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaTeXPrinter {
    private static final DateFormat LATEX_TODAY = new SimpleDateFormat("MMMM dd, yyyy");
    private static final Map<String, String> COMMAND_SYMBOLS = new LinkedHashMap<String, String>();

    public String print(List<LaTeXObject> objects) {
        TextBuilder builder = new TextBuilder();
        this.print(objects, builder);
        return builder.buildString();
    }

    private void print(List<LaTeXObject> objects, TextBuilder builder) {
        for (LaTeXObject object : objects) {
            if (object instanceof LaTeXCommand) {
                this.print((LaTeXCommand)object, builder);
                continue;
            }
            if (object instanceof LaTeXGroup) {
                this.print((LaTeXGroup)object, builder);
                continue;
            }
            if (object instanceof LaTeXString) {
                this.print((LaTeXString)object, builder);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private void print(LaTeXCommand command, TextBuilder builder) {
        char accent = LaTeXPrinter.getAccent(command.getName());
        if (accent > '\u0000') {
            builder.setAccent(accent);
            return;
        }
        String symbol = LaTeXPrinter.getSymbol(command.getName());
        if (symbol != null) {
            builder.append(symbol);
        }
    }

    private void print(LaTeXGroup group, TextBuilder builder) {
        builder.append(this.print(group.getObjects()));
    }

    private void print(LaTeXString string, TextBuilder builder) {
        String value = string.getValue();
        if (value.contains("--")) {
            value = value.replace("---", "\u2014");
            value = value.replace("--", "\u2013");
        }
        if (value.contains("`")) {
            value = value.replace("``", "\u201c");
            value = value.replace("`", "\u2018");
        }
        if (value.contains("'")) {
            value = value.replace("''", "\u201d");
            value = value.replace("'", "\u2019");
        }
        builder.append(value);
    }

    public static String today() {
        Calendar now = Calendar.getInstance();
        return LATEX_TODAY.format(now.getTime());
    }

    private static char getAccent(String name) {
        char c = name.length() == 1 ? name.charAt(0) : (char)'\u0000';
        switch (c) {
            case '\"': 
            case '\'': 
            case '.': 
            case '=': 
            case 'H': 
            case '^': 
            case '`': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'k': 
            case 'r': 
            case 't': 
            case 'u': 
            case 'v': 
            case '~': {
                return c;
            }
        }
        return '\u0000';
    }

    private static char applyAccent(char accent, char c) {
        switch (accent) {
            case '`': {
                switch (c) {
                    case 'A': {
                        return '\u00c0';
                    }
                    case 'E': {
                        return '\u00c8';
                    }
                    case 'a': {
                        return '\u00e0';
                    }
                    case 'e': {
                        return '\u00e8';
                    }
                }
                break;
            }
            case '\'': {
                switch (c) {
                    case 'A': {
                        return '\u00c1';
                    }
                    case 'E': {
                        return '\u00c9';
                    }
                    case 'a': {
                        return '\u00e1';
                    }
                    case 'e': {
                        return '\u00e9';
                    }
                }
                break;
            }
            case '\"': {
                switch (c) {
                    case 'A': {
                        return '\u00c4';
                    }
                    case 'O': {
                        return '\u00d6';
                    }
                    case 'U': {
                        return '\u00dc';
                    }
                    case 'a': {
                        return '\u00e4';
                    }
                    case 'o': {
                        return '\u00f6';
                    }
                    case 'u': {
                        return '\u00fc';
                    }
                }
                break;
            }
            case '~': {
                switch (c) {
                    case 'O': {
                        return '\u00d5';
                    }
                    case 'o': {
                        return '\u00f5';
                    }
                }
                break;
            }
            case 'v': {
                switch (c) {
                    case 'S': {
                        return '\u0160';
                    }
                    case 'Z': {
                        return '\u017d';
                    }
                    case 's': {
                        return '\u0161';
                    }
                    case 'z': {
                        return '\u017e';
                    }
                }
                break;
            }
        }
        return c;
    }

    public static String getSymbol(String name) {
        return COMMAND_SYMBOLS.get(name);
    }

    public static void setSymbol(String name, String symbol) {
        COMMAND_SYMBOLS.put(name, symbol);
    }

    static {
        LaTeXPrinter.setSymbol("#", "#");
        LaTeXPrinter.setSymbol("$", "$");
        LaTeXPrinter.setSymbol("%", "%");
        LaTeXPrinter.setSymbol("&", "&");
        LaTeXPrinter.setSymbol("\\", "\\");
        LaTeXPrinter.setSymbol("^", "^");
        LaTeXPrinter.setSymbol("_", "_");
        LaTeXPrinter.setSymbol("{", "{");
        LaTeXPrinter.setSymbol("}", "}");
        LaTeXPrinter.setSymbol("~", "~");
        LaTeXPrinter.setSymbol("AA", "\u00c5");
        LaTeXPrinter.setSymbol("AE", "\u00c6");
        LaTeXPrinter.setSymbol("O", "\u00d8");
        LaTeXPrinter.setSymbol("SS", "SS");
        LaTeXPrinter.setSymbol("aa", "\u00e5");
        LaTeXPrinter.setSymbol("ae", "\u00e6");
        LaTeXPrinter.setSymbol("o", "\u00f8");
        LaTeXPrinter.setSymbol("ss", "\u00df");
        LaTeXPrinter.setSymbol("textasciicircum", "^");
        LaTeXPrinter.setSymbol("textasciitilde", "~");
        LaTeXPrinter.setSymbol("textbackslash", "\\");
        LaTeXPrinter.setSymbol("textbar", "|");
        LaTeXPrinter.setSymbol("textbraceleft", "{");
        LaTeXPrinter.setSymbol("textbraceright", "}");
        LaTeXPrinter.setSymbol("textcopyrigh", "\u00a9");
        LaTeXPrinter.setSymbol("textdollar", "$");
        LaTeXPrinter.setSymbol("textellipsis", "\u2026");
        LaTeXPrinter.setSymbol("textemdash", "\u2014");
        LaTeXPrinter.setSymbol("textendash", "\u2013");
        LaTeXPrinter.setSymbol("textgreater", ">");
        LaTeXPrinter.setSymbol("textless", "<");
        LaTeXPrinter.setSymbol("textquotedblleft", "\u201c");
        LaTeXPrinter.setSymbol("textquotedblright", "\u201d");
        LaTeXPrinter.setSymbol("textquoteleft", "\u2018");
        LaTeXPrinter.setSymbol("textquoteright", "\u2019");
        LaTeXPrinter.setSymbol("textregistered", "\u00ae");
        LaTeXPrinter.setSymbol("texttrademark", "\u2122");
        LaTeXPrinter.setSymbol("textunderscore", "_");
        LaTeXPrinter.setSymbol("slash", "/");
        LaTeXPrinter.setSymbol("backslash", "\\");
        LaTeXPrinter.setSymbol("endash", "\u2013");
        LaTeXPrinter.setSymbol("emdash", "\u2014");
        LaTeXPrinter.setSymbol("ldots", "\u2026");
        LaTeXPrinter.setSymbol("alpha", "\u03b1");
        LaTeXPrinter.setSymbol("beta", "\u03b2");
        LaTeXPrinter.setSymbol("gamma", "\u03b3");
        LaTeXPrinter.setSymbol("delta", "\u03b4");
        LaTeXPrinter.setSymbol("epsilon", "\u03b5");
        LaTeXPrinter.setSymbol("zeta", "\u03b6");
        LaTeXPrinter.setSymbol("eta", "\u03b7");
        LaTeXPrinter.setSymbol("theta", "\u03b8");
        LaTeXPrinter.setSymbol("iota", "\u03b9");
        LaTeXPrinter.setSymbol("kappa", "\u03ba");
        LaTeXPrinter.setSymbol("lambda", "\u03bb");
        LaTeXPrinter.setSymbol("mu", "\u03bc");
        LaTeXPrinter.setSymbol("nu", "\u03bd");
        LaTeXPrinter.setSymbol("xi", "\u03be");
        LaTeXPrinter.setSymbol("omicron", "\u03bf");
        LaTeXPrinter.setSymbol("pi", "\u03c0");
        LaTeXPrinter.setSymbol("rho", "\u03c1");
        LaTeXPrinter.setSymbol("sigma", "\u03c2");
        LaTeXPrinter.setSymbol("tau", "\u03c3");
        LaTeXPrinter.setSymbol("upsilon", "\u03c4");
        LaTeXPrinter.setSymbol("phi", "\u03c5");
        LaTeXPrinter.setSymbol("chi", "\u03c6");
        LaTeXPrinter.setSymbol("psi", "\u03c7");
        LaTeXPrinter.setSymbol("omega", "\u03c8");
        LaTeXPrinter.setSymbol("today", LaTeXPrinter.today());
        LaTeXPrinter.setSymbol("TeX", "TeX");
        LaTeXPrinter.setSymbol("LaTeX", "LaTeX");
        LaTeXPrinter.setSymbol("LaTeXe", "LaTeX\u03b5");
    }

    private static class TextBuilder {
        private StringBuffer sb = new StringBuffer();
        private char accent = '\u0000';

        private TextBuilder() {
        }

        public void append(String string) {
            char accent = this.getAccent();
            if (accent > '\u0000') {
                if (string.length() > 0) {
                    string = LaTeXPrinter.applyAccent(accent, string.charAt(0)) + string.substring(1);
                }
                this.setAccent('\u0000');
            }
            this.sb.append(string);
        }

        public char getAccent() {
            return this.accent;
        }

        private void setAccent(char accent) {
            this.accent = accent;
        }

        public String buildString() {
            return this.sb.toString();
        }
    }
}

