/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.utils;

import org.apache.log4j.Logger;
import org.openimaj.util.api.auth.DefaultTokenFactory;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class Twitter4jUtil {
    private static Logger logger = Logger.getLogger(Twitter4jUtil.class);

    public static Twitter create() {
        Twitter INSTANCE = null;
        if (INSTANCE == null) {
            Configuration config = Twitter4jUtil.makeConfiguration((TwitterAPIToken)DefaultTokenFactory.get(TwitterAPIToken.class));
            INSTANCE = new TwitterFactory(config).getInstance();
        }
        return INSTANCE;
    }

    private static Configuration makeConfiguration(TwitterAPIToken token) {
        ConfigurationBuilder cb = new ConfigurationBuilder().setOAuthConsumerKey(token.consumerKey).setOAuthConsumerSecret(token.consumerSecret).setOAuthAccessToken(token.accessToken).setOAuthAccessTokenSecret(token.accessSecret);
        cb.setJSONStoreEnabled(true);
        return cb.build();
    }

    public static long handleTwitterException(TwitterException e, long errorWaitTime) {
        if (e.exceededRateLimitation()) {
            long retryAfter = e.getRetryAfter() * 1000;
            logger.debug((Object)String.format("Rate limit exceeded, waiting %dms", retryAfter));
            if (retryAfter < 0L) {
                retryAfter = errorWaitTime * 5L;
            }
            return retryAfter;
        }
        logger.error((Object)"Twitter Exception!", (Throwable)e);
        logger.error((Object)"Waiting a short period of time");
        return errorWaitTime;
    }
}

