/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.collection;

import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Scanner;
import org.openimaj.data.RandomData;
import org.openimaj.io.FileUtils;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.USMFStatus;
import org.openimaj.twitter.collection.TwitterStatusList;
import org.openimaj.twitter.collection.TwitterStatusListUtils;

public class MemoryTwitterStatusList<T extends USMFStatus>
extends ArrayList<T>
implements TwitterStatusList<T> {
    private static final long serialVersionUID = -785707085718120105L;

    public MemoryTwitterStatusList(Collection<T> c) {
        for (USMFStatus twitterStatus : c) {
            this.add(twitterStatus.clone(twitterStatus.getClass()));
        }
    }

    public MemoryTwitterStatusList() {
    }

    public MemoryTwitterStatusList<T> randomSubList(int nelem) {
        MemoryTwitterStatusList<T> kl;
        if (nelem > this.size()) {
            kl = new MemoryTwitterStatusList<T>(this);
            Collections.shuffle(kl);
        } else {
            int[] rnds = RandomData.getUniqueRandomInts((int)nelem, (int)0, (int)this.size());
            kl = new MemoryTwitterStatusList<T>();
            for (int idx : rnds) {
                kl.add(this.get(idx));
            }
        }
        return kl;
    }

    public void writeASCII(PrintWriter out) throws IOException {
        for (int i = 0; i < this.size(); ++i) {
            ((USMFStatus)this.get(i)).writeASCII(out);
            out.println();
        }
    }

    public String asciiHeader() {
        return "";
    }

    public static MemoryTwitterStatusList<USMFStatus> read(File f) throws IOException {
        return MemoryTwitterStatusList.read(new FileInputStream(f), FileUtils.countLines((File)f));
    }

    public static <T extends USMFStatus> MemoryTwitterStatusList<T> read(File f, Class<T> clazz) throws IOException {
        return MemoryTwitterStatusList.read(new FileInputStream(f), FileUtils.countLines((File)f), clazz, USMFStatus.class);
    }

    public static MemoryTwitterStatusList<USMFStatus> read(InputStream is, int nStatus) throws IOException {
        return MemoryTwitterStatusList.read(new BufferedInputStream(is), nStatus, USMFStatus.class, USMFStatus.class);
    }

    public static <T extends USMFStatus> MemoryTwitterStatusList<T> read(InputStream is, int nStatus, Class<T> clazz, Class<? extends GeneralJSON> readClass) throws IOException {
        return MemoryTwitterStatusList.read(new BufferedInputStream(is), nStatus, clazz, USMFStatus.class);
    }

    public static <T extends USMFStatus> MemoryTwitterStatusList<T> read(BufferedInputStream is, int nTweets, Class<T> clazz, Class<? extends GeneralJSON> readClass) throws IOException {
        MemoryTwitterStatusList<T> list = new MemoryTwitterStatusList<T>();
        Scanner scanner = new Scanner(is);
        for (int i = 0; i < nTweets; ++i) {
            USMFStatus s = (USMFStatus)TwitterStatusListUtils.newInstance(clazz);
            s.setGeneralJSONClass(readClass);
            s.readASCII(scanner);
            list.add(s);
        }
        return list;
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] binaryHeader() {
        throw new UnsupportedOperationException();
    }
}

