/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.functions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.openimaj.util.function.MultiFunction;
import org.openimaj.web.scraping.SiteSpecificConsumer;

public class SiteSpecificURLExtractor
implements MultiFunction<URL, URL> {
    private static final Logger logger = Logger.getLogger(SiteSpecificURLExtractor.class);
    protected List<SiteSpecificConsumer> siteSpecific = new ArrayList<SiteSpecificConsumer>();

    public SiteSpecificURLExtractor(List<SiteSpecificConsumer> consumers) {
        this.siteSpecific = consumers;
    }

    public SiteSpecificURLExtractor(SiteSpecificConsumer ... consumers) {
        this.siteSpecific = Arrays.asList(consumers);
    }

    protected SiteSpecificURLExtractor() {
        this.siteSpecific = new ArrayList<SiteSpecificConsumer>();
    }

    public List<URL> apply(URL in) {
        List<URL> imageUrls = this.processURLs(in);
        if (imageUrls == null) {
            return new ArrayList<URL>();
        }
        return imageUrls;
    }

    protected List<URL> processURLs(URL url) {
        logger.debug((Object)("Resolving URL: " + url));
        logger.debug((Object)"Attempting site specific consumers");
        for (SiteSpecificConsumer consumer : this.siteSpecific) {
            if (!consumer.canConsume(url)) continue;
            logger.debug((Object)("Site specific consumer: " + consumer.getClass().getName() + " working on link"));
            List urlList = consumer.consume(url);
            if (urlList == null || urlList.isEmpty()) continue;
            logger.debug((Object)"Site specific consumer returned non-null, returning the URLs");
            return urlList;
        }
        return null;
    }
}

