/*
 * Decompiled with CFR 0.152.
 */
package jal.objects;

import jal.objects.BinaryOperator;
import jal.objects.BinaryPredicate;
import jal.objects.Generator;
import jal.objects.Inspection;
import jal.objects.Predicate;
import jal.objects.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(Object[] source, Object[] destination, int first, int last, int to) {
        if (last > first) {
            System.arraycopy(source, first, destination, to, last - first);
        }
    }

    public static void swap_ranges(Object[] array1, Object[] array2, int first1, int last1, int first2) {
        while (first1 < last1) {
            Object tmp = array2[first2];
            array2[first2] = array1[first1];
            array1[first1] = tmp;
            ++first1;
            ++first2;
        }
    }

    public static void transform(Object[] source, Object[] destination, int first, int last, int to, UnaryOperator f) {
        while (first < last) {
            destination[to++] = f.apply(source[first++]);
        }
    }

    public static void transform(Object[] source1, Object[] source2, Object[] destination, int first1, int last1, int first2, int to, BinaryOperator f) {
        while (first1 < last1) {
            destination[to++] = f.apply(source1[first1++], source2[first2++]);
        }
    }

    public static void replace(Object[] array, int first, int last, Object old_value, Object new_value) {
        while (first < last) {
            if (array[first] == old_value) {
                array[first] = new_value;
            }
            ++first;
        }
    }

    public static void replace_if(Object[] array, int first, int last, Predicate p, Object new_value) {
        while (first < last) {
            if (p.apply(array[first])) {
                array[first] = new_value;
            }
            ++first;
        }
    }

    public static void replace_copy(Object[] source, Object[] destination, int first, int last, int to, Object old_value, Object new_value) {
        while (first < last) {
            Object tmp = source[first++];
            destination[to++] = tmp == old_value ? new_value : tmp;
        }
    }

    public static void replace_copy_if(Object[] source, Object[] destination, int first, int last, int to, Predicate p, Object new_value) {
        while (first < last) {
            Object tmp = source[first++];
            destination[to++] = p.apply(tmp) ? new_value : tmp;
        }
    }

    public static void fill(Object[] array, int first, int last, Object x) {
        while (first < last) {
            array[first++] = x;
        }
    }

    public static void generate(Object[] array, int first, int last, Generator f) {
        while (first < last) {
            array[first++] = f.apply();
        }
    }

    public static int remove_if(Object[] array, int first, int last, Object x) {
        int oldLast = last;
        --first;
        while (true) {
            if (++first < last && array[first] != x) {
                continue;
            }
            while (first < --last && array[last] == x) {
            }
            if (first >= last) {
                return first;
            }
            array[first] = array[last];
        }
    }

    public static int remove_if(Object[] array, int first, int last, Predicate p) {
        int oldLast = last;
        --first;
        while (true) {
            if (++first < last && !p.apply(array[first])) {
                continue;
            }
            while (first < --last && p.apply(array[last])) {
            }
            if (first >= last) {
                return first;
            }
            array[first] = array[last];
        }
    }

    public static int stable_remove(Object[] array, int first, int last, Object x) {
        first = Inspection.find(array, first, last, x);
        int next = Inspection.find_not(array, first, last, x);
        while (next < last) {
            array[first++] = array[next];
            ++next;
            next = Inspection.find_not(array, next, last, x);
        }
        return first;
    }

    public static int stable_remove_if(Object[] array, int first, int last, Predicate p) {
        first = Inspection.find_if(array, first, last, p);
        int next = Inspection.find_if_not(array, first, last, p);
        while (next < last) {
            array[first++] = array[next];
            ++next;
            next = Inspection.find_if_not(array, next, last, p);
        }
        return first;
    }

    public static int remove_copy(Object[] source, Object[] destination, int first, int last, int to, Object value) {
        while (first < last) {
            Object tmp;
            if ((tmp = source[first++]) == value) continue;
            destination[to++] = tmp;
        }
        return to;
    }

    public static int remove_copy_if(Object[] source, Object[] destination, int first, int last, int to, Predicate p) {
        while (first < last) {
            Object tmp;
            if (p.apply(tmp = source[first++])) continue;
            destination[to++] = tmp;
        }
        return to;
    }

    public static int unique(Object[] array, int first, int last) {
        first = Inspection.adjacent_find(array, first, last);
        return Modification.unique_copy(array, array, first, last, first);
    }

    public static int unique(Object[] array, int first, int last, BinaryPredicate p) {
        first = Inspection.adjacent_find(array, first, last, p);
        return Modification.unique_copy(array, array, first, last, first, p);
    }

    public static int unique_copy(Object[] source, Object[] destination, int first, int last, int to) {
        if (first >= last) {
            return to;
        }
        destination[to] = source[first];
        while (++first < last) {
            if (destination[to] == source[first]) continue;
            destination[++to] = source[first];
        }
        return to + 1;
    }

    public static int unique_copy(Object[] source, Object[] destination, int first, int last, int to, BinaryPredicate p) {
        if (first >= last) {
            return to;
        }
        destination[to] = source[first];
        while (++first < last) {
            if (p.apply(destination[to], source[first])) continue;
            destination[++to] = source[first];
        }
        return to + 1;
    }

    public static void reverse(Object[] array, int first, int last) {
        while (first < --last) {
            Object tmp = array[first];
            array[first++] = array[last];
            array[last] = tmp;
        }
    }

    public static void reverse_copy(Object[] array, int first, int last, int to) {
        while (last > first) {
            array[to++] = array[--last];
        }
    }

    public static void reverse_copy(Object[] source, Object[] destination, int first, int last, int to) {
        while (last > first) {
            destination[to++] = source[--last];
        }
    }

    public static void rotate(Object[] array, int first, int middle, int last) {
        if (middle != first && middle != last) {
            Modification.reverse(array, first, middle);
            Modification.reverse(array, middle, last);
            Modification.reverse(array, first, last);
        }
    }

    public static void rotate_copy(Object[] source, Object[] destination, int first, int middle, int last, int to) {
        Modification.copy(source, destination, middle, last, to);
        Modification.copy(source, destination, first, middle, to + (last - middle));
    }

    public static void random_shuffle(Object[] array, int first, int last, Random RNG) {
        for (int i = first + 1; i < last; ++i) {
            int randomPlace = Math.abs(RNG.nextInt()) % (i - first + 1);
            Object tmp = array[randomPlace];
            array[randomPlace] = array[i];
            array[i] = tmp;
        }
    }

    public static void random_shuffle(Object[] array, int first, int last) {
        Modification.random_shuffle(array, first, last, default_RNG);
    }

    public static int partition(Object[] array, int first, int last, Predicate p) {
        --first;
        while (true) {
            if (++first < last && p.apply(array[first])) {
                continue;
            }
            while (first < --last && !p.apply(array[last])) {
            }
            if (first >= last) {
                return first;
            }
            Object tmp = array[first];
            array[first] = array[last];
            array[last] = tmp;
        }
    }

    public static int stable_partition(Object[] array, int first, int last, Predicate p) {
        if (first + 1 < last) {
            int middle = first + (last - first) / 2;
            int firstCut = Modification.stable_partition(array, first, middle, p);
            int secondCut = Modification.stable_partition(array, middle, last, p);
            Modification.rotate(array, firstCut, middle, secondCut);
            return firstCut + (secondCut - middle);
        }
        if (first >= last || !p.apply(array[first])) {
            return first;
        }
        return last;
    }

    private Modification() {
    }
}

