/*
 * Decompiled with CFR 0.152.
 */
package jal.doubles;

import jal.doubles.BinaryOperator;

public final class Numeric {
    public static double accumulate(double[] array, int first, int last, double init) {
        double acc = init;
        while (first < last) {
            acc += array[first++];
        }
        return acc;
    }

    public static double accumulate(double[] array, int first, int last, double init, BinaryOperator op) {
        double acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static double inner_product(double[] array1, double[] array2, int first1, int last1, int first2, double init) {
        double acc = init;
        while (first1 < last1) {
            acc += array1[first1++] * array2[first2++];
        }
        return acc;
    }

    public static double inner_product(double[] array1, double[] array2, int first1, int last1, int first2, double init, BinaryOperator op1, BinaryOperator op2) {
        double acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(double[] source, double[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            double value = dest[to];
            while (++first < last) {
                dest[++to] = value += source[first];
            }
            return to + 1;
        }
        return to;
    }

    public static int partial_sum(double[] source, double[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            double value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(double[] source, double[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            double prev_value = source[first];
            while (++first < last) {
                double cur_value = source[first];
                dest[++to] = cur_value - prev_value;
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(double[] source, double[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            double prev_value = source[first];
            while (++first < last) {
                double cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

