/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.core.QReadWriteLock;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarCache {
    private static QReadWriteLock lock = new QReadWriteLock();
    private static HashMap<String, List<JarFile>> cache;
    private static List<String> classPathDirs;

    JarCache() {
    }

    private static void add(String dirName, JarFile jarFile) {
        List<JarFile> files = cache.get(dirName);
        if (files == null) {
            files = new ArrayList<JarFile>();
            files.add(jarFile);
            cache.put(dirName, files);
        } else if (!files.contains(jarFile)) {
            files.add(jarFile);
        }
    }

    public static void reset(Set<String> jarFileList) {
        lock.lockForWrite();
        cache = new HashMap();
        classPathDirs = new ArrayList<String>();
        for (String jarFileName : jarFileList) {
            try {
                URL url = new URL("jar:" + jarFileName + "!/");
                JarFile file = ((JarURLConnection)url.openConnection()).getJarFile();
                JarCache.add("", file);
                Enumeration<JarEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    int slashPos;
                    JarEntry entry = entries.nextElement();
                    String dirName = "";
                    String entryName = entry.getName();
                    if (entry.isDirectory()) {
                        dirName = entryName.endsWith("/") ? entryName.substring(0, entryName.length() - 1) : entryName;
                    } else {
                        slashPos = entryName.lastIndexOf("/");
                        if (slashPos > 0) {
                            dirName = entryName.substring(0, slashPos);
                        }
                    }
                    if (dirName.startsWith("/")) {
                        dirName = dirName.substring(1);
                    }
                    while (dirName != null) {
                        JarCache.add(dirName, file);
                        slashPos = dirName.lastIndexOf("/");
                        if (slashPos > 0) {
                            dirName = dirName.substring(0, slashPos);
                            continue;
                        }
                        dirName = null;
                    }
                }
                JarCache.add("", file);
            }
            catch (Exception e) {
                classPathDirs.add(jarFileName);
            }
        }
        lock.unlock();
    }

    public static List<JarFile> jarFiles(String entry) {
        lock.lockForRead();
        List<JarFile> files = cache.get(entry);
        lock.unlock();
        return files;
    }

    public static List<String> classPathDirs() {
        return classPathDirs;
    }
}

