/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation;

import javassist.CtClass;
import javassist.CtMethod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openimaj.aop.ClassTransformer;
import org.openimaj.citation.ReferenceListener;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.References;

public class ReferencesClassTransformer
implements ClassTransformer {
    private static Logger logger = LogManager.getLogger(ReferencesClassTransformer.class);

    public void transform(String className, CtClass ctclz) throws Exception {
        CtMethod[] methods;
        Object ann = ctclz.getAnnotation(Reference.class);
        if (ann == null) {
            ann = ctclz.getAnnotation(References.class);
        }
        if (ann != null) {
            logger.trace(String.format("class file transformer invoked for className: %s\n", className));
            ctclz.makeClassInitializer().insertBefore(ReferenceListener.class.getName() + ".addReference(" + ctclz.getName() + ".class);");
        }
        for (CtMethod m : methods = ctclz.getDeclaredMethods()) {
            ann = m.getAnnotation(Reference.class);
            if (ann == null) {
                ann = m.getAnnotation(References.class);
            }
            if (ann == null) continue;
            logger.trace(String.format("class file transformer invoked for className: %s\n; method: ", className, m.getLongName()));
            String code = ReferenceListener.class.getName() + ".addReference(" + ctclz.getName() + ".class,\"" + m.getName() + "\",\"" + m.getLongName() + "\");";
            m.insertBefore(code);
        }
    }
}

