/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.sketch;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;
import org.openimaj.util.sketch.Sketcher;

public class ShortLSHSketcher<OBJECT>
implements Sketcher<OBJECT, short[]> {
    List<HashFunction<OBJECT>> hashFunctions;

    public ShortLSHSketcher(List<HashFunction<OBJECT>> functions) {
        this.hashFunctions = functions;
    }

    @SafeVarargs
    public ShortLSHSketcher(HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        this.hashFunctions.add(first);
        for (HashFunction<OBJECT> r : remainder) {
            this.hashFunctions.add(r);
        }
    }

    public ShortLSHSketcher(HashFunctionFactory<OBJECT> factory, int nFuncs) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        for (int i = 0; i < nFuncs; ++i) {
            this.hashFunctions.add(factory.create());
        }
    }

    public short[] createSketch(OBJECT input) {
        int nele = this.arrayLength();
        short[] sketch = new short[nele];
        int j = 0;
        for (int i = 0; i < nele; ++i) {
            for (int k = 0; k < 16; ++k) {
                int hash = this.hashFunctions.get(j++).computeHashCode(input);
                sketch[i] = (short)(sketch[i] | (short)hash << k);
            }
        }
        return sketch;
    }

    public int bitLength() {
        return this.hashFunctions.size();
    }

    public int arrayLength() {
        return (int)Math.ceil((double)this.hashFunctions.size() / 16.0);
    }
}

