/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.FloatFVComparison;
import org.openimaj.lsh.functions.FloatHashFunction;
import org.openimaj.lsh.functions.FloatHashFunctionFactory;
import org.openimaj.lsh.functions.HammingHelper;
import org.openimaj.util.array.SparseFloatArray;

@Reference(type=ReferenceType.Inproceedings, author={"Indyk, Piotr", "Motwani, Rajeev"}, title="Approximate nearest neighbors: towards removing the curse of dimensionality", year="1998", booktitle="Proceedings of the thirtieth annual ACM symposium on Theory of computing", pages={"604", "", "613"}, url="http://doi.acm.org/10.1145/276698.276876", publisher="ACM", series="STOC '98")
public class FloatHammingFactory
extends FloatHashFunctionFactory {
    int bitsPerDim;

    public FloatHammingFactory(int ndims, MersenneTwister rng, int bitsPerDim) {
        super(ndims, rng);
        this.bitsPerDim = bitsPerDim;
    }

    public Function create() {
        return new Function(this, this.ndims, this.rng);
    }

    @Override
    public FloatFVComparison fvDistanceFunction() {
        if (this.bitsPerDim == 0) {
            return FloatFVComparison.HAMMING;
        }
        return FloatFVComparison.PACKED_HAMMING;
    }

    private class Function
    extends FloatHashFunction {
        private int ham;

        Function(FloatHammingFactory options, int ndims, MersenneTwister rng) {
            super(rng);
            Uniform uniform = new Uniform((RandomEngine)rng);
            this.ham = options.bitsPerDim == 0 ? uniform.nextIntFromTo(0, ndims - 1) : uniform.nextIntFromTo(0, ndims * options.bitsPerDim - 1);
        }

        public int computeHashCode(float[] point) {
            if (FloatHammingFactory.this.bitsPerDim == 0) {
                return point[this.ham] == 0.0f ? 0 : 1;
            }
            int m = this.ham % FloatHammingFactory.this.bitsPerDim;
            int d = this.ham / FloatHammingFactory.this.bitsPerDim;
            return (int)((long)(HammingHelper.convert(point[d]) >>> m) & 1L);
        }

        @Override
        public int computeHashCode(SparseFloatArray array) {
            if (FloatHammingFactory.this.bitsPerDim == 0) {
                return array.get(this.ham) == 0.0f ? 0 : 1;
            }
            int m = this.ham % FloatHammingFactory.this.bitsPerDim;
            int d = this.ham / FloatHammingFactory.this.bitsPerDim;
            return (int)((long)(HammingHelper.convert(array.get(d)) >>> m) & 1L);
        }
    }
}

