/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.lsh.functions.DoubleHashFunction;
import org.openimaj.lsh.functions.DoubleHashFunctionFactory;
import org.openimaj.util.array.SparseDoubleArray;

@Reference(type=ReferenceType.Inproceedings, author={"Lv, Qin", "Charikar, Moses", "Li, Kai"}, title="Image similarity search with compact data structures", year="2004", booktitle="Proceedings of the thirteenth ACM international conference on Information and knowledge management", pages={"208", "", "217"}, url="http://doi.acm.org/10.1145/1031171.1031213", publisher="ACM", series="CIKM '04")
public class DoubleHyperplaneL1Factory
extends DoubleHashFunctionFactory {
    double min = 0.0;
    double max = 1.0;

    public DoubleHyperplaneL1Factory(int ndims, MersenneTwister rng, double min, double max) {
        super(ndims, rng);
        this.min = min;
        this.max = max;
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected DoubleFVComparison fvDistanceFunction() {
        return DoubleFVComparison.CITY_BLOCK;
    }

    private class Function
    extends DoubleHashFunction {
        int dimension;
        double shift;

        Function(int ndims, MersenneTwister rng) {
            super(rng);
            Uniform uniform = new Uniform((RandomEngine)rng);
            this.dimension = uniform.nextIntFromTo(0, ndims - 1);
            this.shift = uniform.nextDoubleFromTo(DoubleHyperplaneL1Factory.this.min, DoubleHyperplaneL1Factory.this.max);
        }

        public int computeHashCode(double[] point) {
            return point[this.dimension] - this.shift >= 0.0 ? 1 : 0;
        }

        @Override
        public int computeHashCode(SparseDoubleArray array) {
            return array.get(this.dimension) - this.shift >= 0.0 ? 1 : 0;
        }
    }
}

