/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.composition;

import cern.jet.random.engine.MersenneTwister;
import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;
import org.openimaj.util.hash.composition.HashComposition;

public class RandomProjectionHashComposition<OBJECT>
extends HashComposition<OBJECT> {
    int[] projection;

    public RandomProjectionHashComposition(MersenneTwister rng, List<HashFunction<OBJECT>> functions) {
        super(functions);
        this.createProjection(rng);
    }

    @SafeVarargs
    public RandomProjectionHashComposition(MersenneTwister rng, HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        super(first, remainder);
        this.createProjection(rng);
    }

    public RandomProjectionHashComposition(MersenneTwister rng, HashFunctionFactory<OBJECT> factory, int nFuncs) {
        super(factory, nFuncs);
        this.createProjection(rng);
    }

    private void createProjection(MersenneTwister rng) {
        this.projection = new int[this.hashFunctions.size()];
        for (int i = 0; i < this.hashFunctions.size(); ++i) {
            this.projection[i] = rng.nextInt();
        }
    }

    public int computeHashCode(OBJECT object) {
        int hash = 0;
        for (int i = 0; i < this.projection.length; ++i) {
            hash += this.projection[i] * ((HashFunction)this.hashFunctions.get(i)).computeHashCode(object);
        }
        return hash;
    }
}

