/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.approximate;

import java.util.Arrays;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.ShortNearestNeighbours;
import org.openimaj.knn.approximate.ShortKDTreeEnsemble;
import org.openimaj.util.pair.IntFloatPair;

@Reference(type=ReferenceType.Inproceedings, author={"Marius Muja", "David G. Lowe"}, title="Fast Approximate Nearest Neighbors with Automatic Algorithm Configuration", year="2009", booktitle="International Conference on Computer Vision Theory and Application VISSAPP'09)", pages={"331", "340"}, publisher="INSTICC Press")
public class ShortNearestNeighboursKDTree
extends ShortNearestNeighbours {
    public static final int DEFAULT_NCHECKS = 768;
    public static final int DEFAULT_NTREES = 8;
    public final ShortKDTreeEnsemble kdt;
    public final int nchecks;

    public ShortNearestNeighboursKDTree(short[][] pnts, int ntrees, int nchecks) {
        this.kdt = new ShortKDTreeEnsemble(pnts, ntrees);
        this.nchecks = nchecks;
    }

    @Override
    public int numDimensions() {
        return this.kdt.pnts[0].length;
    }

    @Override
    public int size() {
        return this.kdt.pnts.length;
    }

    public void searchKNN(short[][] qus, int K, int[][] argmins, float[][] mins) {
        K = Math.min(K, this.kdt.pnts.length);
        IntFloatPair[] nns = new IntFloatPair[K];
        int N = qus.length;
        for (int n = 0; n < N; ++n) {
            this.kdt.search(qus[n], K, nns, this.nchecks);
            for (int k = 0; k < K; ++k) {
                argmins[n][k] = nns[k].first;
                mins[n][k] = nns[k].second;
            }
        }
    }

    public void searchNN(short[][] qus, int[] argmins, float[] mins) {
        int N = qus.length;
        IntFloatPair[] nn = new IntFloatPair[1];
        for (int n = 0; n < N; ++n) {
            this.kdt.search(qus[n], 1, nn, this.nchecks);
            argmins[n] = nn[0].first;
            mins[n] = nn[0].second;
        }
    }

    public void searchKNN(List<short[]> qus, int K, int[][] argmins, float[][] mins) {
        K = Math.min(K, this.kdt.pnts.length);
        IntFloatPair[] nns = new IntFloatPair[K];
        int N = qus.size();
        for (int n = 0; n < N; ++n) {
            this.kdt.search(qus.get(n), K, nns, this.nchecks);
            for (int k = 0; k < K; ++k) {
                argmins[n][k] = nns[k].first;
                mins[n][k] = nns[k].second;
            }
        }
    }

    @Override
    public void searchNN(List<short[]> qus, int[] argmins, float[] mins) {
        int N = qus.size();
        IntFloatPair[] nn = new IntFloatPair[1];
        for (int n = 0; n < N; ++n) {
            this.kdt.search(qus.get(n), 1, nn, this.nchecks);
            argmins[n] = nn[0].first;
            mins[n] = nn[0].second;
        }
    }

    @Override
    public List<IntFloatPair> searchKNN(short[] query, int K) {
        K = Math.min(K, this.kdt.pnts.length);
        IntFloatPair[] nns = new IntFloatPair[K];
        this.kdt.search(query, K, nns, this.nchecks);
        return Arrays.asList(nns);
    }

    @Override
    public IntFloatPair searchNN(short[] query) {
        IntFloatPair[] nn = new IntFloatPair[1];
        this.kdt.search(query, 1, nn, this.nchecks);
        return nn[0];
    }

    public static final class Factory
    implements NearestNeighboursFactory<ShortNearestNeighboursKDTree, short[]> {
        int ntrees;
        int nchecks;

        public Factory() {
            this.ntrees = 8;
            this.nchecks = 768;
        }

        public Factory(int ntrees, int nchecks) {
            this.ntrees = ntrees;
            this.nchecks = nchecks;
        }

        public ShortNearestNeighboursKDTree create(short[][] data) {
            return new ShortNearestNeighboursKDTree(data, this.ntrees, this.nchecks);
        }
    }
}

