/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import org.openimaj.feature.ShortFVComparator;
import org.openimaj.knn.NearestNeighbours;
import org.openimaj.util.pair.IntFloatPair;

public abstract class ShortNearestNeighbours
implements NearestNeighbours<short[], float[], IntFloatPair> {
    public static void distanceFunc(short[] qu, short[][] pnts, float[] dsq_out) {
        int N = pnts.length;
        int D = pnts[0].length;
        for (int n = 0; n < N; ++n) {
            dsq_out[n] = 0.0f;
            for (int d = 0; d < D; ++d) {
                int n2 = n;
                dsq_out[n2] = dsq_out[n2] + (float)((qu[d] - pnts[n][d]) * (qu[d] - pnts[n][d]));
            }
        }
    }

    public static float distanceFunc(short[] qu, short[] pnt) {
        int D = pnt.length;
        float dsq_out = 0.0f;
        for (int d = 0; d < D; ++d) {
            dsq_out += (float)((qu[d] - pnt[d]) * (qu[d] - pnt[d]));
        }
        return dsq_out;
    }

    public static float distanceFunc(ShortFVComparator distance, short[] qu, short[] pnt) {
        if (distance == null) {
            return ShortNearestNeighbours.distanceFunc(qu, pnt);
        }
        if (distance.isDistance()) {
            return (float)distance.compare(qu, pnt);
        }
        return -((float)distance.compare(qu, pnt));
    }

    public static void distanceFunc(ShortFVComparator distance, short[] qu, short[][] pnts, float[] dsq_out) {
        if (distance == null) {
            ShortNearestNeighbours.distanceFunc(qu, pnts, dsq_out);
            return;
        }
        int N = pnts.length;
        if (distance.isDistance()) {
            for (int n = 0; n < N; ++n) {
                dsq_out[n] = (float)distance.compare(qu, pnts[n]);
            }
        } else {
            for (int n = 0; n < N; ++n) {
                dsq_out[n] = -((float)distance.compare(qu, pnts[n]));
            }
        }
    }

    public abstract int numDimensions();
}

