/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.util.List;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.YagoEntityExactMatcherFactory;
import org.openimaj.text.nlp.textpipe.annotations.NamedEntityAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractNEAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class YagoNEAnnotator
extends AbstractNEAnnotator {
    private int cw = 1;
    public YagoEntityExactMatcherFactory.YagoEntityExactMatcher yagoMatcher = YagoEntityExactMatcherFactory.getMatcher();

    @Override
    void performAnnotation(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
        List<SentenceAnnotation> sentences = annotation.getAnnotationsFor(SentenceAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            String context = this.getContextFrom(sentences.subList(Math.max(0, i - this.cw), Math.min(i + this.cw + 1, sentences.size())));
            this.annotateSentence(sentences.get(i), context);
        }
    }

    private void annotateSentence(SentenceAnnotation sentence, String context) {
        List<NamedEntity> ents = this.yagoMatcher.matchExact(sentence.getAnnotationsFor(TokenAnnotation.class), context);
        for (NamedEntity ent : ents) {
            NamedEntityAnnotation nea = new NamedEntityAnnotation();
            nea.namedEntity = ent;
            nea.tokensMatched.addAll(sentence.getAnnotationsFor(TokenAnnotation.class).subList(ent.startToken, ent.stopToken));
            sentence.addAnnotation(nea);
        }
    }

    private String getContextFrom(List<SentenceAnnotation> sents) {
        StringBuffer result = new StringBuffer();
        for (SentenceAnnotation sent : sents) {
            result.append(sent.text + " ");
        }
        return result.toString();
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
        if (!annotation.getAnnotationKeyList().contains(SentenceAnnotation.class)) {
            throw new MissingRequiredAnnotationException("No SentenceAnnotations found");
        }
    }
}

