/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotations;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.textpipe.annotations.TextPipeAnnotation;
import org.openimaj.text.nlp.tokenisation.ReversableToken;

public class TokenAnnotation
extends TextPipeAnnotation
implements ReversableToken {
    String stringToken;
    String raw;
    public int start;
    public int stop;

    public TokenAnnotation(String token, String raw, int start, int stop) {
        this.stringToken = token;
        this.start = start;
        this.stop = stop;
        this.raw = raw;
    }

    public String getStringToken() {
        return this.stringToken;
    }

    @Override
    public String getRawString() {
        return this.raw;
    }

    @Override
    public String reverse(List<? extends ReversableToken> tokens) {
        ArrayList<String> raws = new ArrayList<String>();
        for (ReversableToken reversableToken : tokens) {
            raws.add(reversableToken.getRawString());
        }
        return StringUtils.join(raws, (String)"");
    }
}

