/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotations;

import org.openimaj.text.nlp.textpipe.annotations.NamedEntityAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.POSAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.PhraseAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPPOSAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPPhraseChunkAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPSentenceAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPTokenAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.YagoNEAnnotator;

public class PipePlayground {
    public static void main(String[] args) {
        RawTextAnnotation rta = new RawTextAnnotation("The tall curtains");
        System.setProperty("org.openimaj.text.opennlp.models.token", "/org/openimaj/text/opennlp/models/en-token.bin");
        System.setProperty("org.openimaj.text.opennlp.models.sent", "/org/openimaj/text/opennlp/models/en-sent.bin");
        System.setProperty("org.openimaj.text.opennlp.models.pos", "/org/openimaj/text/opennlp/models/en-pos-maxent.bin");
        System.setProperty("org.openimaj.text.opennlp.models.chunker", "/org/openimaj/text/opennlp/models/en-chunker.bin");
        OpenNLPTokenAnnotator ta = new OpenNLPTokenAnnotator();
        OpenNLPSentenceAnnotator sa = new OpenNLPSentenceAnnotator();
        OpenNLPPOSAnnotator pa = new OpenNLPPOSAnnotator();
        OpenNLPPhraseChunkAnnotator pca = new OpenNLPPhraseChunkAnnotator();
        YagoNEAnnotator yna = new YagoNEAnnotator();
        try {
            sa.annotate(rta);
            ta.annotate(rta);
            pa.annotate(rta);
            pca.annotate(rta);
            yna.annotate(rta);
        }
        catch (MissingRequiredAnnotationException e1) {
            e1.printStackTrace();
        }
        for (SentenceAnnotation sentence : rta.getAnnotationsFor(SentenceAnnotation.class)) {
            System.out.println(sentence.text);
            if (sentence.getAnnotationKeyList().contains(NamedEntityAnnotation.class)) {
                for (NamedEntityAnnotation ne : sentence.getAnnotationsFor(NamedEntityAnnotation.class)) {
                    System.out.println(ne.namedEntity.rootName);
                    System.out.println((Object)ne.namedEntity.type);
                }
            }
            for (TokenAnnotation token : sentence.getAnnotationsFor(TokenAnnotation.class)) {
                POSAnnotation.PartOfSpeech pos = token.getAnnotationsFor(POSAnnotation.class).get((int)0).pos;
                PhraseAnnotation.Phrase ph = token.getAnnotationsFor(PhraseAnnotation.class).get((int)0).phrase;
                String phraseOrder = token.getAnnotationsFor(PhraseAnnotation.class).get(0).getOrder();
                System.out.println(token.stringToken + "  " + pos.toString() + "  " + pos.DESCRIPTION + "    " + ph.toString() + "-" + phraseOrder);
                System.out.println(sentence.text.substring(token.start, token.stop));
                System.out.println("|" + token.getRawString() + "|");
                String fromRaw = rta.text.substring(sentence.start + token.start, sentence.start + token.stop);
                System.out.print(fromRaw + "\n");
            }
        }
    }
}

