/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotations;

import org.openimaj.text.nlp.textpipe.annotations.TextPipeAnnotation;

public class POSAnnotation
extends TextPipeAnnotation {
    public PartOfSpeech pos;

    public POSAnnotation(PartOfSpeech pos) {
        this.pos = pos;
    }

    public static enum PartOfSpeech {
        CC("Coordinating conjunction"),
        CD("Cardinal number"),
        DT("Determiner"),
        EX("Existential there"),
        FW("Foreign word"),
        IN("Preposition or subordinating conjunction"),
        JJ("Adjective"),
        JJR("Adjective, comparative"),
        JJS("Adjective, superlative"),
        LS("List item marker"),
        MD("Modal"),
        NN("Noun, singular or mass"),
        NNS("Noun, plural"),
        NNP("Proper noun, singular"),
        NNPS("Proper noun, plural"),
        PDT("Predeterminer"),
        POS("Possessive ending"),
        PRP("Personal pronoun"),
        PRP$("Possessive pronoun (prolog version PRP-S)"),
        RB("Adverb"),
        RBR("Adverb, comparative"),
        RBS("Adverb, superlative"),
        RP("Particle"),
        SYM("Symbol"),
        TO("to"),
        UH("Interjection"),
        VB("Verb, base form"),
        VBD("Verb, past tense"),
        VBG("Verb, gerund or present participle"),
        VBN("Verb, past participle"),
        VBP("Verb, non-3rd person singular present"),
        VBZ("Verb, 3rd person singular present"),
        WDT("Wh-determiner"),
        WP("Wh-pronoun"),
        WP$("Possessive wh-pronoun (prolog version WP-S)"),
        WRB("Wh-adverb"),
        UK("Unknown");

        public final String DESCRIPTION;

        private PartOfSpeech(String description) {
            this.DESCRIPTION = description;
        }

        public static PartOfSpeech getPOSfromString(String pennAbreviation) {
            for (PartOfSpeech pos : PartOfSpeech.values()) {
                if (!pos.toString().equals(pennAbreviation)) continue;
                return pos;
            }
            return UK;
        }
    }
}

