/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotations;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.text.nlp.textpipe.annotations.POSAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TextPipeAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;

public class AnnotationUtils {
    public static List<String> getStringTokensFromTokenAnnotationList(List<TokenAnnotation> tokens) {
        ArrayList<String> result = new ArrayList<String>();
        for (TokenAnnotation tokenAnnotation : tokens) {
            result.add(tokenAnnotation.stringToken);
        }
        return result;
    }

    public static List<String> getStringPOSsFromTokenAnnotationList(List<TokenAnnotation> tokens) {
        ArrayList<String> result = new ArrayList<String>();
        for (TokenAnnotation tokenAnnotation : tokens) {
            POSAnnotation pos = tokenAnnotation.getAnnotationsFor(POSAnnotation.class).get(0);
            if (pos.equals((Object)POSAnnotation.PartOfSpeech.UK)) {
                result.add(tokenAnnotation.stringToken);
                continue;
            }
            result.add(tokenAnnotation.getAnnotationsFor(POSAnnotation.class).get(0).toString());
        }
        return result;
    }

    public static String[] ListToArray(List<String> convert) {
        String[] result = new String[convert.size()];
        for (int i = 0; i < convert.size(); ++i) {
            result[i] = convert.get(i);
        }
        return result;
    }

    public static boolean allHaveAnnotation(List<? extends TextPipeAnnotation> toBeChecked, Class<? extends TextPipeAnnotation> check) {
        for (TextPipeAnnotation textPipeAnnotation : toBeChecked) {
            if (textPipeAnnotation.getAnnotationKeyList().contains(check)) continue;
            return false;
        }
        return true;
    }
}

