/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.model.wordlist.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.io.ReadableASCII;

@Reference(author={"Janyce Wiebe", "Theresa Wilson", "Claire Cardie"}, title="Annotating expressions of opinions and emotions in language. ", type=ReferenceType.Article, year="2005")
public class TFF
implements ReadableASCII {
    public ArrayList<Clue> entriesList;
    public Map<String, List<Clue>> entriesMap = new HashMap<String, List<Clue>>();

    public TFF() {
        this.entriesList = new ArrayList();
    }

    public void readASCII(Scanner in) throws IOException {
        while (in.hasNextLine()) {
            String line = in.nextLine();
            if (line.startsWith("#")) continue;
            String[] parts = line.split(" ");
            Clue entry = new Clue();
            for (String part : parts) {
                String[] namevalue = part.split("=");
                if (namevalue.length != 2) continue;
                String name = namevalue[0];
                String value = namevalue[1];
                if (name.equals("type")) {
                    entry.type = Enum.valueOf(Type.class, value);
                    continue;
                }
                if (name.equals("len")) {
                    int len = Integer.parseInt(value);
                    entry.words = new String[len];
                    entry.poses = new Pos[len];
                    entry.stemmed = new boolean[len];
                    continue;
                }
                if (name.startsWith("word")) {
                    int wordN = Integer.parseInt(name.substring(4)) - 1;
                    entry.words[wordN] = value;
                    continue;
                }
                if (name.startsWith("pos")) {
                    int posN = Integer.parseInt(name.substring(3)) - 1;
                    entry.poses[posN] = Enum.valueOf(Pos.class, value);
                    continue;
                }
                if (name.startsWith("stemmed")) {
                    int stemN = Integer.parseInt(name.substring(7)) - 1;
                    entry.stemmed[stemN] = value.equals("y");
                    continue;
                }
                if (name.equals("polannsrc")) {
                    entry.polannsrc = value;
                    continue;
                }
                if (!name.equals("mpqapolarity")) continue;
                entry.polarity = Enum.valueOf(Polarity.class, value);
            }
            this.entriesList.add(entry);
            for (String string : entry.words) {
                List<Clue> wordEntries = this.entriesMap.get(string);
                if (wordEntries == null) {
                    wordEntries = new ArrayList<Clue>();
                    this.entriesMap.put(string, wordEntries);
                }
                wordEntries.add(entry);
            }
        }
    }

    public String asciiHeader() {
        return "";
    }

    public TFF clone() {
        TFF tff = new TFF();
        for (Clue entry : this.entriesList) {
            tff.entriesList.add(entry);
            for (String string : entry.words) {
                List<Clue> wordEntries = tff.entriesMap.get(string);
                if (wordEntries == null) {
                    wordEntries = new ArrayList<Clue>();
                    tff.entriesMap.put(string, wordEntries);
                }
                wordEntries.add(entry);
            }
        }
        return tff;
    }

    public static class Clue {
        public Type type;
        public String[] words;
        public Pos[] poses;
        public boolean[] stemmed;
        public String polannsrc;
        public Polarity polarity;

        public Clue clone() {
            Clue entry = new Clue();
            entry.type = this.type;
            entry.polannsrc = this.polannsrc;
            entry.polarity = this.polarity;
            entry.words = Arrays.copyOf(this.words, this.words.length);
            entry.poses = Arrays.copyOf(this.poses, this.poses.length);
            entry.stemmed = Arrays.copyOf(this.stemmed, this.stemmed.length);
            return entry;
        }
    }

    public static enum Polarity {
        both,
        neutral,
        negative,
        weakneg,
        strongneg,
        positive,
        strongpos,
        weakpos;

    }

    public static enum Pos {
        adj,
        adverb,
        anypos,
        noun,
        verb;

    }

    public static enum Type {
        strongsubj,
        weaksubj;

    }
}

