/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.model.wordlist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.IdentityFeatureExtractor;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.text.nlp.sentiment.model.TokenListSentimentAnnotator;
import org.openimaj.text.nlp.sentiment.model.wordlist.util.TFF;
import org.openimaj.text.nlp.sentiment.type.BipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.TFFCountSentiment;

@Reference(author={"Janyce Wiebe", "Theresa Wilson", "Claire Cardie"}, title="Annotating expressions of opinions and emotions in language. ", type=ReferenceType.Article, year="2005")
public class MPQATokenList
extends TokenListSentimentAnnotator<IdentityFeatureExtractor<List<String>>, MPQATokenList> {
    private static final String DEFAULT_MODEL = "/org/openimaj/text/sentiment/mpqa/subjclueslen1polar.tff";
    private TFF model;

    public MPQATokenList() throws IOException {
        super(new IdentityFeatureExtractor());
        this.model = (TFF)IOUtils.read((InputStream)MPQATokenList.class.getResourceAsStream(DEFAULT_MODEL), TFF.class);
    }

    public MPQATokenList(File f) throws IOException {
        super(new IdentityFeatureExtractor());
        this.model = (TFF)IOUtils.read((File)f, TFF.class);
    }

    public MPQATokenList(MPQATokenList mpqa) {
        super(new IdentityFeatureExtractor());
        this.model = mpqa.model.clone();
    }

    public List<ScoredAnnotation<BipolarSentiment>> annotate(List<String> words) {
        ArrayList<ScoredAnnotation<BipolarSentiment>> ret = new ArrayList<ScoredAnnotation<BipolarSentiment>>();
        TFFCountSentiment counter = new TFFCountSentiment(words.size());
        for (String word : words) {
            List<TFF.Clue> clueList = this.model.entriesMap.get(word);
            if (clueList == null) continue;
            for (TFF.Clue clue : clueList) {
                counter.incrementClue(clue, 1);
            }
        }
        ret.add(new ScoredAnnotation((Object)counter.bipolar(), 1.0f));
        return ret;
    }
}

