/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.openimaj.experiment.evaluation.classification.BasicClassificationResult;
import org.openimaj.experiment.evaluation.classification.ClassificationEvaluator;
import org.openimaj.experiment.evaluation.classification.ClassificationResult;
import org.openimaj.experiment.evaluation.classification.analysers.roc.ROCAnalyser;
import org.openimaj.experiment.evaluation.classification.analysers.roc.ROCResult;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.text.nlp.EntityTweetTokeniser;
import org.openimaj.text.nlp.TweetTokeniserException;
import org.openimaj.text.nlp.namedentity.EntityAnnotator;
import org.openimaj.text.nlp.namedentity.EntityExtractionResourceBuilder;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.YagoEntityCandidateFinderFactory;
import org.openimaj.text.nlp.namedentity.YagoEntityCompleteAnnotator;
import org.openimaj.text.nlp.namedentity.YagoEntityContextScorerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class YagoCompanyAnnotatorEvaluator {
    private static final String CLASSIFICATION = "Organistaion";
    private static BufferedWriter logOut;
    private static boolean logging;
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    private Map<FileEntityLocation, Set<String>> actual;
    private Map<FileEntityLocation, ClassificationResult<String>> results;
    private final YagoEntityCompleteAnnotator ycca;
    private EntityTweetTokeniser tt;
    private ClassificationEvaluator<ROCResult<String>, String, FileEntityLocation> ce;
    private ROCAnalyser<FileEntityLocation, String> ra;
    private boolean verbose = false;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("You have not given me a directory for the Test data.");
            System.exit(1);
        }
        if (args.length == 2) {
            YagoCompanyAnnotatorEvaluator.createLogging(args[1]);
            logging = true;
        } else {
            System.out.println("No logging file specified.");
            logging = false;
        }
        YagoCompanyAnnotatorEvaluator ya = new YagoCompanyAnnotatorEvaluator();
        ya.run(args[0]);
    }

    private static void createLogging(String logFilePath) {
        File f = new File(logFilePath);
        if (!f.isFile()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileWriter fstream = null;
        try {
            fstream = new FileWriter(logFilePath);
            logOut = new BufferedWriter(fstream);
            logOut.write("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YagoCompanyAnnotatorEvaluator() {
        YagoEntityCandidateFinderFactory.YagoEntityCandidateFinder ycf = null;
        ycf = YagoEntityCandidateFinderFactory.createFromAliasFile(EntityExtractionResourceBuilder.getDefaultAliasFilePath());
        YagoEntityContextScorerFactory.YagoEntityContextScorer ycs = null;
        ycs = YagoEntityContextScorerFactory.createFromIndexFile(EntityExtractionResourceBuilder.getDefaultIndexDirectoryPath());
        this.ycca = new YagoEntityCompleteAnnotator(ycs, ycf);
    }

    public void run(String testDirectory) {
        System.out.println("Started....");
        this.buildTruthAndClassifications(testDirectory);
        this.ra = new ROCAnalyser();
        this.ce = new ClassificationEvaluator(this.results, this.actual, this.ra);
        ROCResult analysisResult = (ROCResult)this.ce.analyse(this.ce.evaluate());
        System.out.println(analysisResult.getDetailReport());
        this.doMyCalcs();
        if (logging) {
            try {
                logOut.flush();
                logOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void doMyCalcs() {
        double fp = 0.0;
        double tp = 0.0;
        double fn = 0.0;
        for (FileEntityLocation fe : this.results.keySet()) {
            if (this.actual.keySet().contains(fe)) {
                tp += 1.0;
                continue;
            }
            fp += 1.0;
        }
        for (FileEntityLocation fe : this.actual.keySet()) {
            if (this.results.keySet().contains(fe)) continue;
            fn += 1.0;
        }
        System.out.println("Precision : " + tp / (tp + fp));
        System.out.println("Recall : " + tp / (tp + fn));
    }

    private void buildTruthAndClassifications(String testDirectory) {
        File f = new File(testDirectory);
        this.actual = new HashMap<FileEntityLocation, Set<String>>();
        this.results = new HashMap<FileEntityLocation, ClassificationResult<String>>();
        if (f.isDirectory()) {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = null;
            try {
                this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            for (File s : f.listFiles()) {
                String name = s.getName();
                this.print("#################Processing " + name);
                if (!name.substring(name.lastIndexOf(".") + 1).equals("xml")) continue;
                Document doc = null;
                try {
                    doc = this.docBuilder.parse(s);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                doc.getDocumentElement().normalize();
                HashMap<Integer, String> res = this.getResultsFrom(doc.getElementsByTagName("TextWithNodes").item(0).getTextContent(), s.getAbsolutePath());
                HashMap<Integer, String> act = this.getActualFrom(doc.getElementsByTagName("TextWithNodes").item(0).getTextContent(), doc.getElementsByTagName("AnnotationSet"), s.getAbsolutePath());
                this.print("---------MY MISSES----------");
                for (int key : act.keySet()) {
                    if (res.keySet().contains(key)) continue;
                    this.print(act.get(key));
                }
                this.print("---------THEIR MISSES----------");
                for (int key : res.keySet()) {
                    if (act.keySet().contains(key)) continue;
                    this.print(res.get(key));
                }
            }
        }
    }

    private HashMap<Integer, String> getResultsFrom(String textContent, String filePath) {
        this.print("---------RESULTS----------");
        try {
            this.tt = new EntityTweetTokeniser(textContent);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (TweetTokeniserException e) {
            e.printStackTrace();
        }
        ArrayList tokens = (ArrayList)this.tt.getStringTokens();
        List<ScoredAnnotation<HashMap<String, Object>>> annos = this.ycca.annotate(tokens);
        HashMap<Integer, String> r = new HashMap<Integer, String>();
        for (ScoredAnnotation<HashMap<String, Object>> anno : annos) {
            if (((HashMap)anno.annotation).get(EntityAnnotator.TYPE) != NamedEntity.Type.Organisation.toString()) continue;
            FileEntityLocation fe = this.getFE(anno, textContent, tokens);
            BasicClassificationResult c = new BasicClassificationResult();
            c.put((Object)CLASSIFICATION, 1.0);
            fe.file = filePath;
            this.results.put(fe, (ClassificationResult<String>)c);
            if (fe.start >= 0 && fe.start < textContent.length() && fe.stop >= 0 && fe.stop < textContent.length() && fe.stop > fe.start) {
                String s = textContent.substring(fe.start, fe.stop) + " " + fe.start + ", " + fe.stop;
                r.put(fe.start + fe.stop, s);
                this.print(s);
                continue;
            }
            System.err.println("Substring out of range for :" + ((HashMap)anno.annotation).get(EntityAnnotator.URI));
        }
        return r;
    }

    private FileEntityLocation getFE(ScoredAnnotation<HashMap<String, Object>> anno, String textContent, ArrayList<String> tokens) {
        int sInd = (Integer)((HashMap)anno.annotation).get(EntityAnnotator.START_TOKEN);
        String sToken = tokens.get(sInd);
        int minStartChar = StringUtils.join(tokens.subList(0, sInd), (String)"").length();
        int startCharOff = textContent.substring(minStartChar).indexOf(sToken);
        int startChar = minStartChar + startCharOff;
        int eInd = (Integer)((HashMap)anno.annotation).get(EntityAnnotator.END_TOKEN);
        String eToken = tokens.get(eInd);
        minStartChar = StringUtils.join(tokens.subList(0, eInd), (String)"").length();
        startCharOff = textContent.substring(minStartChar).indexOf(eToken);
        int endChar = minStartChar + startCharOff + eToken.length();
        FileEntityLocation fe = new FileEntityLocation();
        fe.start = startChar;
        fe.stop = endChar;
        return fe;
    }

    private HashMap<Integer, String> getActualFrom(String textContent, NodeList anoSets, String filePath) {
        this.print("---------Actual----------");
        HashSet<String> c = new HashSet<String>();
        c.add(CLASSIFICATION);
        HashMap<Integer, String> r = new HashMap<Integer, String>();
        for (int i = 0; i < anoSets.getLength(); ++i) {
            Node n = anoSets.item(i);
            NamedNodeMap m = n.getAttributes();
            if (m.getNamedItem("Name") == null || !m.getNamedItem("Name").getNodeValue().equals("Key")) continue;
            NodeList anoChildren = n.getChildNodes();
            for (int j = 0; j < anoChildren.getLength(); ++j) {
                Node child = anoChildren.item(j);
                if (!child.hasAttributes() || child.getAttributes().getNamedItem("Type") == null || !child.getAttributes().getNamedItem("Type").getNodeValue().equals("Organization")) continue;
                int startchar = Integer.parseInt(child.getAttributes().getNamedItem("StartNode").getNodeValue());
                int endchar = Integer.parseInt(child.getAttributes().getNamedItem("EndNode").getNodeValue());
                FileEntityLocation fe = new FileEntityLocation();
                fe.file = filePath;
                fe.start = startchar;
                fe.stop = endchar;
                this.actual.put(fe, c);
                String s = textContent.substring(fe.start, fe.stop) + " " + fe.start + ", " + fe.stop;
                r.put(fe.start + fe.stop, s);
                this.print(s);
            }
        }
        return r;
    }

    public static String getRawStringFromTest(String path) {
        File f = new File(path);
        Document doc = null;
        DocumentBuilderFactory factory = null;
        DocumentBuilder docBuilder = null;
        factory = DocumentBuilderFactory.newInstance();
        docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            doc = docBuilder.parse(f);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        doc.getDocumentElement().normalize();
        return doc.getElementsByTagName("TextWithNodes").item(0).getTextContent();
    }

    private void print(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
        if (logging) {
            try {
                logOut.append(message + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class FileEntityLocation {
        String file;
        int start;
        int stop;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + this.start;
            result = 31 * result + this.stop;
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileEntityLocation)) {
                return false;
            }
            FileEntityLocation comp = (FileEntityLocation)obj;
            if (!comp.file.equals(this.file)) {
                return false;
            }
            if (comp.start != this.start) {
                return false;
            }
            return comp.stop == this.stop;
        }
    }
}

