/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;

public class SeedBuilder {
    private String yagoDirectory;
    private static String seedDirectory = "seedDirectory";

    private SeedBuilder(String yagoTSVDirectory) {
        this.yagoDirectory = yagoTSVDirectory;
    }

    public static void main(String[] args) {
        SeedBuilder sb = new SeedBuilder(args[0]);
        sb.build();
    }

    public void build() {
        System.out.println("Building hash...");
        HashSet<String> filters = null;
        try {
            filters = this.buildEntityHash(this.yagoDirectory);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Total Entities : " + filters.size());
        FileFilterer ff = new FileFilterer(this.yagoDirectory + File.separator + "means.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "means_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[2];
            }
        };
        ff.filter();
        ff = new FileFilterer(this.yagoDirectory + File.separator + "isCalled.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "isCalled_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[1];
            }
        };
        ff.filter();
        ff = new FileFilterer(this.yagoDirectory + File.separator + "created.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "created_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[1];
            }
        };
        ff.filter();
        ff = new FileFilterer(this.yagoDirectory + File.separator + "hasWikipediaUrl.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "hasWikipediaUrl_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[1];
            }
        };
        ff.filter();
        ff = new FileFilterer(this.yagoDirectory + File.separator + "hasAnchorText.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "hasAnchorText_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[1];
            }
        };
        ff.filter();
        ff = new FileFilterer(this.yagoDirectory + File.separator + "hasWikipediaAnchorText.tsv", this.yagoDirectory + File.separator + seedDirectory + File.separator + "hasWikipediaAnchorText_stripped.tsv", (HashSet)filters){

            @Override
            protected String getCompareValue(String line) {
                String[] values = line.split("\\s+");
                return values[1];
            }
        };
        ff.filter();
        System.out.println("Done");
    }

    private HashSet<String> buildEntityHash(String directoryPath) throws FileNotFoundException {
        HashSet<String> result = new HashSet<String>();
        BufferedReader org = SeedBuilder.openIn(directoryPath + File.separator + seedDirectory + File.separator + "wordnet_organization_108008335.txt");
        String s = null;
        int clashes = 0;
        try {
            while ((s = org.readLine()) != null) {
                String[] values = s.split("\\s+");
                if (result.contains(values[1])) {
                    ++clashes;
                    continue;
                }
                result.add(values[1]);
            }
            org.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedReader per = SeedBuilder.openIn(directoryPath + File.separator + seedDirectory + File.separator + "wordnet_person_100007846.txt");
        s = null;
        try {
            while ((s = per.readLine()) != null) {
                String[] values = s.split("\\s+");
                if (result.contains(values[1])) {
                    ++clashes;
                    continue;
                }
                result.add(values[1]);
            }
            per.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedReader loc = SeedBuilder.openIn(directoryPath + File.separator + seedDirectory + File.separator + "wordnet_location_100027167.txt");
        s = null;
        try {
            while ((s = loc.readLine()) != null) {
                String[] values = s.split("\\s+");
                if (result.contains(values[1])) {
                    ++clashes;
                    continue;
                }
                result.add(values[1]);
            }
            loc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Ent Clashes: " + clashes);
        return result;
    }

    private static BufferedReader openIn(String path) throws FileNotFoundException {
        FileReader fr = null;
        fr = new FileReader(path);
        BufferedReader br = new BufferedReader(fr);
        return br;
    }

    private abstract class FileFilterer {
        private HashSet<String> filterValues;
        private BufferedReader in;
        private BufferedWriter out;
        private String inString;

        public FileFilterer(String fileToFilter, String filteredResultsFile, HashSet<String> validFilterValues) {
            this.filterValues = validFilterValues;
            try {
                this.in = SeedBuilder.openIn(fileToFilter);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.openOut(filteredResultsFile);
            this.inString = fileToFilter;
        }

        private void openOut(String filteredResultsFile) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(filteredResultsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.out = new BufferedWriter(fw);
            try {
                this.out.write("");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void filter() {
            System.out.println("Filtering : " + this.inString);
            int count = 0;
            int vcount = 0;
            try {
                String s;
                while ((s = this.in.readLine()) != null) {
                    ++count;
                    if (!this.filterValues.contains(this.getCompareValue(s))) continue;
                    this.out.append(s + "\n");
                    ++vcount;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.in.close();
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Finished : " + this.inString + "\nFiltered " + count + " to " + vcount);
        }

        protected abstract String getCompareValue(String var1);
    }
}

