/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class QuickIndexer {
    private final Directory index;
    private IndexWriter writer;
    private boolean finalised = false;
    private final StandardAnalyzer analyzer;

    public QuickIndexer(Directory index) {
        this.index = index;
        this.analyzer = new StandardAnalyzer(Version.LUCENE_40);
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_40, (Analyzer)this.analyzer);
        try {
            this.writer = new IndexWriter(index, config);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (LockObtainFailedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addDocument(Document entry) throws CorruptIndexException, IOException {
        if (!this.finalised) {
            this.writer.addDocument((Iterable)entry);
        }
    }

    public void addDocumentFromFields(String[] names, String[] values, FieldType[] type) throws CorruptIndexException, IOException {
        if (!this.finalised) {
            Document doc = new Document();
            for (int i = 0; i < names.length; ++i) {
                doc.add((IndexableField)new Field(names[i], values[i], type[i]));
            }
            this.writer.addDocument((Iterable)doc);
        }
    }

    public void finalise() throws CorruptIndexException, IOException {
        this.writer.close();
        this.finalised = true;
    }

    public Directory getIndex() {
        return this.index;
    }

    public StandardAnalyzer getAnalyzer() {
        return this.analyzer;
    }
}

