/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.language;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.io.wrappers.Readable2DArrayBinary;
import org.openimaj.io.wrappers.ReadableArrayBinary;
import org.openimaj.io.wrappers.Writeable2DArrayBinary;
import org.openimaj.io.wrappers.WriteableArrayBinary;
import org.openimaj.math.matrix.MatrixUtils;

public class LanguageModel
implements ReadWriteableBinary {
    DenseMatrix naiveBayesPC;
    DenseMatrix naiveBayesPTC;
    String[] naiveBayesClasses;
    TIntObjectHashMap<int[]> tk_output;
    int[] tk_nextmove;
    int naiveBayesNFeats;

    public LanguageModel() {
    }

    public LanguageModel(Map<String, Object> languageModel) {
        Iterator iterator;
        List nb_pc_list = (List)languageModel.get("nb_pc");
        double[][] nb_pc_darr = new double[1][nb_pc_list.size()];
        int i = 0;
        Iterator iterator2 = nb_pc_list.iterator();
        while (iterator2.hasNext()) {
            double value = (Double)iterator2.next();
            nb_pc_darr[0][i++] = value;
        }
        this.naiveBayesPC = new DenseMatrix(nb_pc_darr);
        List nb_ptc_list = (List)languageModel.get("nb_ptc");
        double[][] nb_ptc_darr = new double[nb_ptc_list.size()][((List)nb_ptc_list.get(0)).size()];
        i = 0;
        for (List row : nb_ptc_list) {
            int j = 0;
            iterator = row.iterator();
            while (iterator.hasNext()) {
                double val = (Double)iterator.next();
                nb_ptc_darr[i][j++] = val;
            }
            ++i;
        }
        this.naiveBayesPTC = new DenseMatrix(nb_ptc_darr);
        this.naiveBayesNFeats = this.naiveBayesPTC.numColumns() * this.naiveBayesPTC.numRows() / this.naiveBayesPC.numColumns();
        List nb_classes_list = (List)languageModel.get("nb_classes");
        this.naiveBayesClasses = nb_classes_list.toArray(new String[nb_classes_list.size()]);
        this.tk_output = new TIntObjectHashMap();
        Map tk_output_map = (Map)languageModel.get("tk_outp");
        for (Map.Entry entry : tk_output_map.entrySet()) {
            i = 0;
            int[] entryArr = new int[((List)entry.getValue()).size()];
            Iterator iterator3 = ((List)entry.getValue()).iterator();
            while (iterator3.hasNext()) {
                double entryVal = (Double)iterator3.next();
                entryArr[i++] = (int)entryVal;
            }
            this.tk_output.put(Integer.parseInt((String)entry.getKey()), (Object)entryArr);
        }
        List tk_nextmove_list = (List)languageModel.get("tk_nextmove");
        this.tk_nextmove = new int[tk_nextmove_list.size()];
        i = 0;
        iterator = tk_nextmove_list.iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            this.tk_nextmove[i++] = (int)val;
        }
    }

    public void writeBinary(final DataOutput out) throws IOException {
        new Writeable2DArrayBinary(MatrixUtils.mtjToDoubleArray((DenseMatrix)this.naiveBayesPC)).writeBinary(out);
        new Writeable2DArrayBinary(MatrixUtils.mtjToDoubleArray((DenseMatrix)this.naiveBayesPTC)).writeBinary(out);
        WriteableArrayBinary<String> stringWriter = new WriteableArrayBinary<String>(this.naiveBayesClasses){

            protected void writeValue(String v, DataOutput out) throws IOException {
                out.writeUTF(v);
            }
        };
        stringWriter.writeBinary(out);
        out.writeInt(this.tk_output.size());
        this.tk_output.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

            public boolean execute(int key, int[] value) {
                try {
                    out.writeInt(key);
                    out.writeInt(value.length);
                    for (int i : value) {
                        out.writeInt(i);
                    }
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        });
        out.writeInt(this.tk_nextmove.length);
        for (int nextmove : this.tk_nextmove) {
            out.writeInt(nextmove);
        }
    }

    public byte[] binaryHeader() {
        return "LANGMODEL".getBytes();
    }

    public void readBinary(DataInput in) throws IOException {
        Readable2DArrayBinary matrixReader = new Readable2DArrayBinary((double[][])null);
        matrixReader.readBinary(in);
        this.naiveBayesPC = new DenseMatrix(matrixReader.value);
        matrixReader.readBinary(in);
        this.naiveBayesPTC = new DenseMatrix(matrixReader.value);
        this.naiveBayesNFeats = this.naiveBayesPTC.numColumns() * this.naiveBayesPTC.numRows() / this.naiveBayesPC.numColumns();
        ReadableArrayBinary<String> readableClasses = new ReadableArrayBinary<String>(null){

            protected String readValue(DataInput in) throws IOException {
                return in.readUTF();
            }

            protected String[] createEmpty(int sz) throws IOException {
                return new String[sz];
            }
        };
        readableClasses.readBinary(in);
        this.naiveBayesClasses = (String[])readableClasses.value;
        int nTKOut = in.readInt();
        this.tk_output = new TIntObjectHashMap(nTKOut);
        for (int i = 0; i < nTKOut; ++i) {
            int key = in.readInt();
            int length = in.readInt();
            int[] data = new int[length];
            for (int j = 0; j < length; ++j) {
                data[j] = in.readInt();
            }
            this.tk_output.put(key, (Object)data);
        }
        int nextMoveLength = in.readInt();
        this.tk_nextmove = new int[nextMoveLength];
        for (int i = 0; i < nextMoveLength; ++i) {
            this.tk_nextmove[i] = in.readInt();
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof LanguageModel)) {
            return false;
        }
        final LanguageModel that = (LanguageModel)other;
        boolean equal = true;
        equal = Arrays.deepEquals(this.naiveBayesClasses, that.naiveBayesClasses);
        if (!equal) {
            return false;
        }
        boolean bl = equal = this.naiveBayesNFeats == that.naiveBayesNFeats;
        if (!equal) {
            return false;
        }
        equal = Arrays.deepEquals((Object[])MatrixUtils.mtjToDoubleArray((DenseMatrix)this.naiveBayesPC), (Object[])MatrixUtils.mtjToDoubleArray((DenseMatrix)that.naiveBayesPC));
        if (!equal) {
            return false;
        }
        equal = Arrays.deepEquals((Object[])MatrixUtils.mtjToDoubleArray((DenseMatrix)this.naiveBayesPTC), (Object[])MatrixUtils.mtjToDoubleArray((DenseMatrix)that.naiveBayesPTC));
        if (!equal) {
            return false;
        }
        equal = Arrays.equals(this.tk_nextmove, that.tk_nextmove);
        if (!equal) {
            return false;
        }
        equal = this.tk_output.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

            public boolean execute(int key, int[] value) {
                return Arrays.equals(value, (int[])that.tk_output.get(key));
            }
        });
        if (!equal) {
            return false;
        }
        return equal;
    }
}

