/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

abstract class RecordCache {
    private final AtomicLong maxRecords;
    private final AtomicLong recordCount;

    public RecordCache() throws IOException {
        this(Long.MAX_VALUE);
    }

    public RecordCache(long maxRecords) throws IOException {
        this.maxRecords = new AtomicLong(maxRecords);
        this.recordCount = new AtomicLong();
    }

    public final long getMaxRecords() {
        return this.maxRecords.get();
    }

    public final void setMaxRecords(long maxRecords) {
        this.maxRecords.set(maxRecords);
    }

    public final long getRecordCount() {
        if (this.isValid()) {
            return this.recordCount.get();
        }
        throw new IllegalStateException();
    }

    public final void storeRecord(byte[] data) throws IOException {
        long spareSlots = this.maxRecords.get() - this.recordCount.get();
        if (spareSlots > 0L) {
            this.storeRecordInternal(data);
            this.recordCount.incrementAndGet();
        } else if (spareSlots == 0L) {
            this.recordCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeRecords(RecordCache otherCache) throws IOException {
        if (this.recordCount.get() <= this.maxRecords.get()) {
            RecordIterator recIter = otherCache.getRecords();
            try {
                byte[] record;
                while ((record = recIter.next()) != null && this.recordCount.incrementAndGet() <= this.maxRecords.get()) {
                    this.storeRecordInternal(record);
                }
            }
            finally {
                recIter.close();
            }
        }
    }

    protected abstract void storeRecordInternal(byte[] var1) throws IOException;

    public final void clear() throws IOException {
        this.clearInternal();
        this.recordCount.set(0L);
    }

    protected abstract void clearInternal() throws IOException;

    public final RecordIterator getRecords() {
        if (this.isValid()) {
            return this.getRecordsInternal();
        }
        throw new IllegalStateException();
    }

    protected abstract RecordIterator getRecordsInternal();

    public final boolean isValid() {
        return this.recordCount.get() <= this.maxRecords.get();
    }

    public abstract void discard() throws IOException;
}

