/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.memory.model.MemLiteral;

public class NumericMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -4077489124945558638L;
    private final Number number;

    public NumericMemLiteral(Object creator, String label, Number number, URI datatype) {
        super(creator, label, datatype);
        this.number = number;
    }

    public NumericMemLiteral(Object creator, Number number, URI datatype) {
        this(creator, number.toString(), number, datatype);
    }

    public NumericMemLiteral(Object creator, byte number) {
        this(creator, number, XMLSchema.BYTE);
    }

    public NumericMemLiteral(Object creator, short number) {
        this(creator, number, XMLSchema.SHORT);
    }

    public NumericMemLiteral(Object creator, int number) {
        this(creator, number, XMLSchema.INT);
    }

    public NumericMemLiteral(Object creator, long n) {
        this(creator, n, XMLSchema.LONG);
    }

    public NumericMemLiteral(Object creator, float n) {
        this(creator, Float.valueOf(n), XMLSchema.FLOAT);
    }

    public NumericMemLiteral(Object creator, double n) {
        this(creator, n, XMLSchema.DOUBLE);
    }

    public byte byteValue() {
        return this.number.byteValue();
    }

    public short shortValue() {
        return this.number.shortValue();
    }

    public int intValue() {
        return this.number.intValue();
    }

    public long longValue() {
        return this.number.longValue();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }
}

