/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailBooleanQuery
extends SailQuery
implements BooleanQuery {
    protected SailBooleanQuery(ParsedBooleanQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super(tupleQuery, sailConnection);
    }

    public ParsedBooleanQuery getParsedQuery() {
        return (ParsedBooleanQuery)super.getParsedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate() throws QueryEvaluationException {
        boolean bl;
        ParsedBooleanQuery parsedBooleanQuery = this.getParsedQuery();
        TupleExpr tupleExpr = parsedBooleanQuery.getTupleExpr();
        Dataset dataset = this.getDataset();
        if (dataset == null) {
            dataset = parsedBooleanQuery.getDataset();
        }
        SailConnection sailCon = this.getConnection().getSailConnection();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter = sailCon.evaluate(tupleExpr, dataset, this.getBindings(), this.getIncludeInferred());
        bindingsIter = this.enforceMaxQueryTime(bindingsIter);
        try {
            bl = bindingsIter.hasNext();
        }
        catch (Throwable throwable) {
            try {
                bindingsIter.close();
                throw throwable;
            }
            catch (SailException e) {
                throw new QueryEvaluationException(e.getMessage(), e);
            }
        }
        bindingsIter.close();
        return bl;
    }
}

