/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class Substring
implements Function {
    public String getURI() {
        return ((Object)FN.SUBSTRING).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 2 || args.length > 3) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for SUBSTR: " + args.length);
        }
        Value argValue = args[0];
        Value startIndexValue = args[1];
        Value lengthValue = null;
        if (args.length > 2) {
            lengthValue = args[2];
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                int startIndex;
                String lexicalValue;
                block18: {
                    lexicalValue = literal.getLabel();
                    startIndex = 0;
                    if (startIndexValue instanceof Literal) {
                        try {
                            startIndex = ((Literal)startIndexValue).intValue() - 1;
                            if (startIndex < 0) {
                                throw new ValueExprEvaluationException("illegal start index value (expected 1 or larger): " + startIndexValue);
                            }
                            break block18;
                        }
                        catch (NumberFormatException e) {
                            throw new ValueExprEvaluationException("illegal start index value (expected int value): " + startIndexValue);
                        }
                    }
                    if (startIndexValue != null) {
                        throw new ValueExprEvaluationException("illegal start index value (expected literal value): " + startIndexValue);
                    }
                }
                int endIndex = lexicalValue.length();
                if (lengthValue instanceof Literal) {
                    try {
                        int length = ((Literal)lengthValue).intValue();
                        endIndex = startIndex + length;
                    }
                    catch (NumberFormatException e) {
                        throw new ValueExprEvaluationException("illegal length value (expected int value): " + lengthValue);
                    }
                } else if (lengthValue != null) {
                    throw new ValueExprEvaluationException("illegal length value (expected literal value): " + lengthValue);
                }
                try {
                    String language = literal.getLanguage();
                    lexicalValue = lexicalValue.substring(startIndex, endIndex);
                    if (language != null) {
                        return valueFactory.createLiteral(lexicalValue, language);
                    }
                    if (((Object)XMLSchema.STRING).equals(literal.getDatatype())) {
                        return valueFactory.createLiteral(lexicalValue, XMLSchema.STRING);
                    }
                    return valueFactory.createLiteral(lexicalValue);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ValueExprEvaluationException("could not determine substring", e);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function substring: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function substring: " + argValue);
    }
}

