/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrBefore
implements Function {
    public String getURI() {
        return ((Object)FN.SUBSTRING_BEFORE).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRBEFORE: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            if (QueryEvaluationUtil.isStringLiteral(leftLit) && QueryEvaluationUtil.isStringLiteral(rightLit)) {
                String leftLanguage = leftLit.getLanguage();
                URI leftDt = leftLit.getDatatype();
                String lexicalValue = leftLit.getLabel();
                String substring = rightLit.getLabel();
                int index = lexicalValue.indexOf(substring);
                String substringBefore = "";
                if (index > -1) {
                    substringBefore = lexicalValue.substring(0, index);
                }
                if (leftLanguage != null) {
                    return valueFactory.createLiteral(substringBefore, leftLanguage);
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringBefore, leftDt);
                }
                return valueFactory.createLiteral(substringBefore);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
    }
}

