/*
 * Decompiled with CFR 0.152.
 */
package org.oc.ocvolume.dsp;

public class endPt {
    static final int frameSize = 80;

    public static short[] absCut(short[] sample) {
        if (sample.length > 3200) {
            boolean[] crossingBoolean = endPt.zeroCrossingBoolean(sample);
            int[] energy = endPt.avgEnergy(sample);
            int[] crossing = endPt.zeroCrossing(sample, energy, crossingBoolean);
            short[] chopped = endPt.chopping(sample, crossing);
            return chopped;
        }
        return sample;
    }

    public static short[] chopping(short[] sample, int[] cut) {
        cut[0] = cut[0] * 80;
        cut[1] = cut[1] * 80;
        short[] chopFile = new short[cut[1] - cut[0]];
        int c = 0;
        while (c < chopFile.length) {
            chopFile[c] = sample[cut[0] + c];
            ++c;
        }
        return chopFile;
    }

    public static int[] avgEnergy(short[] sample) {
        double energyConst = 1.95;
        int[] energyCut = new int[2];
        double[] energyFrame = new double[sample.length / 80];
        double runningSum = 0.0;
        double noiseEnergy = 0.0;
        double noiseEnergyThreshold = 0.0;
        int location = 0;
        int backwardLocation = 0;
        boolean belowThreshold = true;
        boolean valleyFound = true;
        int c = 0;
        while (c < energyFrame.length) {
            runningSum = 0.0;
            int d = c * 80;
            while (d < (c + 1) * 80) {
                runningSum += (double)(sample[d] * sample[d]);
                ++d;
            }
            energyFrame[c] = runningSum / 80.0;
            ++c;
        }
        runningSum = 0.0;
        c = 0;
        while (c < 20) {
            runningSum += energyFrame[c];
            ++c;
        }
        noiseEnergy = runningSum / 20.0;
        noiseEnergyThreshold = noiseEnergy * 1.95;
        energyCut[1] = energyFrame.length - 22;
        energyCut[0] = 20;
        location = 20;
        belowThreshold = true;
        while (location < energyFrame.length - 36 && belowThreshold) {
            if (energyFrame[location] > noiseEnergyThreshold) {
                runningSum = 0.0;
                c = 1;
                while (c < 17) {
                    if (energyFrame[location + c] > noiseEnergyThreshold) {
                        runningSum += 1.0;
                    }
                    ++c;
                }
                if (runningSum >= 13.0) {
                    belowThreshold = false;
                    energyCut[0] = location;
                    valleyFound = true;
                    backwardLocation = 0;
                    while (valleyFound && backwardLocation < 16 && location - backwardLocation > 20) {
                        if (energyFrame[location - backwardLocation - 1] < energyFrame[location - backwardLocation]) {
                            energyCut[0] = location - backwardLocation - 1;
                        } else {
                            valleyFound = false;
                        }
                        ++backwardLocation;
                    }
                }
            }
            ++location;
        }
        runningSum = 0.0;
        c = energyFrame.length - 21;
        while (c < energyFrame.length) {
            runningSum += energyFrame[c];
            ++c;
        }
        noiseEnergy = runningSum / 20.0;
        noiseEnergyThreshold = noiseEnergy * 1.95;
        energyCut[1] = energyFrame.length - 22;
        location = energyFrame.length - 22;
        belowThreshold = true;
        while (location > 35 && belowThreshold) {
            if (energyFrame[location] > noiseEnergyThreshold) {
                runningSum = 0.0;
                c = 1;
                while (c < 17) {
                    if (energyFrame[location - c] > noiseEnergyThreshold) {
                        runningSum += 1.0;
                    }
                    ++c;
                }
                if (runningSum >= 13.0) {
                    belowThreshold = false;
                    energyCut[1] = location;
                    valleyFound = true;
                    backwardLocation = 0;
                    while (valleyFound && backwardLocation < 16 && location + backwardLocation < energyFrame.length - 22) {
                        if (energyFrame[location + backwardLocation + 1] < energyFrame[location + backwardLocation]) {
                            energyCut[1] = location + backwardLocation + 1;
                        } else {
                            valleyFound = false;
                        }
                        ++backwardLocation;
                    }
                    energyCut[1] = energyCut[1] + 1;
                }
            }
            --location;
        }
        return energyCut;
    }

    private static double[] energyGraph(short[] sample) {
        double runningSum = 0.0;
        double[] energyFrame = new double[sample.length / 80];
        int c = 0;
        while (c < energyFrame.length) {
            runningSum = 0.0;
            int d = c * 80;
            while (d < (c + 1) * 80) {
                runningSum += (double)(sample[d] * sample[d]);
                ++d;
            }
            energyFrame[c] = runningSum / 80.0;
            ++c;
        }
        return energyFrame;
    }

    public static boolean[] zeroCrossingBoolean(short[] sample) {
        boolean[] crossingBoolean = new boolean[sample.length];
        int c = 0;
        while (c < sample.length - 1) {
            if (sample[c] > 0 && sample[c + 1] < 0 || sample[c] < 0 && sample[c + 1] > 0) {
                crossingBoolean[c] = true;
            }
            ++c;
        }
        return crossingBoolean;
    }

    public static int[] zeroCrossing(short[] sample, int[] energy, boolean[] crossing) {
        double crossingConst = 12.5;
        int[] crossingCut = new int[]{energy[0], energy[1] - 1};
        double[] crossingFrame = new double[sample.length / 80];
        double crossingSD = 0.0;
        double IZC = 0.0;
        double IZCT = 0.15625;
        int crossingPeak = 0;
        double runningSum = 0.0;
        int location = 0;
        int c = 0;
        while (c < crossingFrame.length) {
            runningSum = 0.0;
            int d = c * 80;
            while (d < (c + 1) * 80) {
                if (crossing[d]) {
                    runningSum += 1.0;
                }
                ++d;
            }
            crossingFrame[c] = runningSum / 80.0;
            ++c;
        }
        runningSum = 0.0;
        c = 0;
        while (c < 20) {
            runningSum += crossingFrame[c];
            ++c;
        }
        IZC = runningSum / 20.0;
        runningSum = 0.0;
        c = 0;
        while (c < 20) {
            runningSum += crossingFrame[c] * crossingFrame[c];
            ++c;
        }
        crossingSD = Math.sqrt(runningSum / 20.0 - IZC * IZC);
        if (0.15625 > IZC * 2.0 * crossingSD) {
            IZCT = IZC * 2.0 * crossingSD;
        }
        IZCT *= 12.5;
        location = crossingCut[0] - 16;
        if (location < 20) {
            location = 20;
        }
        crossingPeak = location;
        while (location != crossingCut[0]) {
            if (crossingFrame[crossingPeak] < crossingFrame[location]) {
                crossingPeak = location;
            }
            ++location;
        }
        if (IZCT < crossingFrame[crossingPeak]) {
            crossingCut[0] = crossingPeak;
            location = crossingCut[0] - 10;
            if (location < 20) {
                location = 20;
            }
            crossingPeak = location;
            while (location != crossingCut[0]) {
                if (crossingFrame[crossingPeak] >= crossingFrame[location]) {
                    crossingPeak = location;
                }
                ++location;
            }
            crossingCut[0] = crossingPeak;
        }
        runningSum = 0.0;
        c = crossingFrame.length - 21;
        while (c < crossingFrame.length) {
            runningSum += crossingFrame[c];
            ++c;
        }
        IZC = runningSum / 20.0;
        runningSum = 0.0;
        c = crossingFrame.length - 21;
        while (c < crossingFrame.length) {
            runningSum += crossingFrame[c] * crossingFrame[c];
            ++c;
        }
        crossingSD = Math.sqrt(runningSum / 20.0 - IZC * IZC);
        IZCT = 0.15625;
        if (0.15625 > IZC * 2.0 * crossingSD) {
            IZCT = IZC * 2.0 * crossingSD;
        }
        IZCT *= 12.5;
        location = crossingCut[1] + 16;
        if (location > crossingFrame.length - 22) {
            location = crossingFrame.length - 22;
        }
        crossingPeak = location;
        while (location != crossingCut[1]) {
            if (crossingFrame[crossingPeak] < crossingFrame[location]) {
                crossingPeak = location;
            }
            --location;
        }
        if (IZCT < crossingFrame[crossingPeak]) {
            crossingCut[1] = crossingPeak;
            location = crossingCut[1] + 10;
            if (location > crossingFrame.length - 22) {
                location = crossingFrame.length - 22;
            }
            crossingPeak = location;
            while (location != crossingCut[1]) {
                if (crossingFrame[crossingPeak] >= crossingFrame[location]) {
                    crossingPeak = location;
                }
                --location;
            }
            crossingCut[1] = crossingPeak;
        }
        crossingCut[1] = crossingCut[1] + 1;
        return crossingCut;
    }

    private static double[] crossingGraph(short[] sample) {
        boolean[] crossing = endPt.zeroCrossingBoolean(sample);
        double[] crossingFrame = new double[sample.length / 80];
        double runningSum = 0.0;
        int c = 0;
        while (c < crossingFrame.length) {
            runningSum = 0.0;
            int d = c * 80;
            while (d < (c + 1) * 80) {
                if (crossing[d]) {
                    runningSum += 1.0;
                }
                ++d;
            }
            crossingFrame[c] = runningSum / 80.0;
            ++c;
        }
        return crossingFrame;
    }
}

