/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.multihelp.HelpViewer;
import org.multihelp.file.FileNode;

public class HTMLFile
extends FileNode {
    private File fileLocation;
    private boolean isDirectory;
    private Icon icon = null;
    private String text = "";
    private Filter filter = new Filter();

    public HTMLFile(File file) {
        super(file);
        this.fileLocation = file;
        this.isDirectory = file.isDirectory();
        if (file.getName().endsWith(".html")) {
            this.icon = new ImageIcon("icons/html.png");
            this.text = file.getName().substring(0, file.getName().lastIndexOf(".html"));
        } else if (file.getName().endsWith(".xml")) {
            this.icon = new ImageIcon("icons/xml.png");
            this.text = file.getName().substring(0, file.getName().lastIndexOf(".xml"));
        } else {
            this.text = file.getName();
        }
    }

    @Override
    public void setPage(HelpViewer viewer) {
        block7: {
            try {
                if (this.isDirectory) {
                    File loc = new File(String.valueOf(this.fileLocation.getCanonicalPath()) + File.pathSeparator + "index.html");
                    if (loc.exists()) {
                        viewer.setPage(loc.toURI().toURL());
                        break block7;
                    }
                    HTMLDocument doc = new HTMLDocument();
                    try {
                        doc.insertString(0, this.generateDefaultIndex(), null);
                        doc.setBase(this.fileLocation.toURI().toURL());
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    viewer.setContentType("text/html");
                    viewer.setDocument(doc);
                    break block7;
                }
                viewer.setPage(this.fileLocation.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getStackTrace(), "ERROR", 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getStackTrace(), "ERROR", 0);
            }
        }
    }

    protected String generateDefaultIndex() {
        if (this.fileLocation.isDirectory() && this.fileLocation.listFiles().length > 0) {
            File[] list = this.fileLocation.listFiles();
            StringBuffer ret = new StringBuffer("<html><body><ul>");
            int i = 0;
            while (i < list.length) {
                ret.append("<li><a href=\"" + list[i].getName() + "\">" + list[i].getName() + "</a></li>");
                ++i;
            }
            ret.append("<ul></body></html>");
            return ret.toString();
        }
        if (this.fileLocation.isDirectory()) {
            return "<html><body>ERROR: Empty directory in the help system.</body></html>";
        }
        return "<html><body>INTERNAL ERROR: Loading non-existant file</body></html>";
    }

    @Override
    public void traverseFileSystem(File root, int depth) {
        File[] children;
        if (depth < 512 && (children = root.listFiles()) != null && children.length != 0) {
            int i = 0;
            while (i < children.length) {
                if (this.filter.accept(children[i])) {
                    FileNode childNode = FileNode.determineType(children[i]);
                    this.add(childNode);
                    childNode.setParent(this);
                    childNode.traverseFileSystem(children[i], depth + 1);
                }
                ++i;
            }
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public class Filter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            if (pathname.getName().endsWith(".html") || pathname.getName().endsWith(".htm")) {
                return !pathname.getName().equals("index.html");
            }
            return false;
        }
    }
}

