/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public class AudioMethodsPlayback {
    public static PlayThread playAudioInputStreamInterruptible(AudioInputStream audio_input_stream, SourceDataLine source_data_line) throws Exception {
        AudioFormat source_data_line_format;
        AudioFormat audio_input_format = audio_input_stream.getFormat();
        if (!audio_input_format.matches(source_data_line_format = source_data_line.getFormat())) {
            throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
        }
        PlayThread play_thread = null;
        play_thread = new PlayThread(source_data_line, audio_input_stream);
        play_thread.start();
        return play_thread;
    }

    public static void playAudioInputStream(AudioInputStream audio_input_stream, SourceDataLine source_data_line) throws Exception {
        AudioFormat source_data_line_format;
        AudioFormat audio_input_format = audio_input_stream.getFormat();
        if (!audio_input_format.matches(source_data_line_format = source_data_line.getFormat())) {
            throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
        }
        PlayThread play_thread = new PlayThread(source_data_line, audio_input_stream);
        play_thread.start();
    }

    public static class PlayThread
    extends Thread {
        private byte[] rw_buffer;
        private boolean stop_playing;
        private SourceDataLine source_data_line = null;
        private AudioInputStream audio_input_stream = null;

        PlayThread(SourceDataLine source_data_line, AudioInputStream audio_input_stream) throws Exception {
            AudioFormat audio_input_format = audio_input_stream.getFormat();
            AudioFormat source_data_line_format = source_data_line.getFormat();
            if (!audio_input_format.matches(source_data_line_format)) {
                throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
            }
            float buffer_duration_in_seconds = 0.25f;
            int buffer_size = AudioMethods.getNumberBytesNeeded(buffer_duration_in_seconds, source_data_line.getFormat());
            if (source_data_line == null) {
                // empty if block
            }
            if (audio_input_stream == null) {
                // empty if block
            }
            this.source_data_line = source_data_line;
            this.audio_input_stream = audio_input_stream;
            this.rw_buffer = new byte[buffer_size];
            this.stop_playing = false;
        }

        @Override
        public void run() {
            this.stop_playing = false;
            try {
                int position;
                while ((position = this.audio_input_stream.read(this.rw_buffer, 0, this.rw_buffer.length)) != -1) {
                    if (position > 0) {
                        this.source_data_line.write(this.rw_buffer, 0, position);
                    }
                    if (!this.stop_playing) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                System.out.println(e);
                System.exit(0);
            }
            if (!this.stop_playing) {
                this.source_data_line.drain();
            }
            this.source_data_line.close();
        }

        public void stopPlaying() {
            this.stop_playing = true;
        }
    }
}

