/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsRecording;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class RecordingFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private AudioInputStream last_recorded_audio;
    private AudioMethodsRecording.RecordThread record_thread;
    private AudioMethodsPlayback.PlayThread playback_thread;
    Controller controller;
    private JFileChooser save_file_chooser;
    private AudioFormatJFrame audio_format_selector;
    private JButton choose_encoding_format_button;
    private JButton display_current_audio_format_button;
    private JButton record_button;
    private JButton stop_recording_button;
    private JButton play_recording_button;
    private JButton stop_playback_button;
    private JButton cancel_button;
    private JButton save_button;
    private JComboBox choose_file_format_combo_box;

    public RecordingFrame(Controller c) {
        this.setTitle("Record Audio");
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecordingFrame.this.cancel();
            }
        });
        this.controller = c;
        this.record_thread = null;
        this.last_recorded_audio = null;
        this.playback_thread = null;
        this.save_file_chooser = null;
        this.audio_format_selector = new AudioFormatJFrame();
        AudioFormat default_format = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
        this.audio_format_selector.setAudioFormat(default_format);
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.setLayout(new GridLayout(6, 2, horizontal_gap, vertical_gap));
        this.choose_encoding_format_button = new JButton("Change Encoding Format");
        this.choose_encoding_format_button.addActionListener(this);
        this.add(this.choose_encoding_format_button);
        this.display_current_audio_format_button = new JButton("Display Current Encoding");
        this.display_current_audio_format_button.addActionListener(this);
        this.add(this.display_current_audio_format_button);
        this.record_button = new JButton("Record");
        this.record_button.addActionListener(this);
        this.add(this.record_button);
        this.stop_recording_button = new JButton("Stop Recording");
        this.stop_recording_button.addActionListener(this);
        this.add(this.stop_recording_button);
        this.play_recording_button = new JButton("Play Last Recording");
        this.play_recording_button.addActionListener(this);
        this.add(this.play_recording_button);
        this.stop_playback_button = new JButton("Stop Playback");
        this.stop_playback_button.addActionListener(this);
        this.add(this.stop_playback_button);
        this.choose_file_format_combo_box = new JComboBox();
        String[] file_types = AudioMethods.getAvailableFileFormatTypes();
        int i = 0;
        while (i < file_types.length) {
            this.choose_file_format_combo_box.addItem(file_types[i]);
            ++i;
        }
        this.choose_file_format_combo_box.setBackground(this.getContentPane().getBackground());
        this.add(new JLabel("File Format For Saving:"));
        this.add(this.choose_file_format_combo_box);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.add(this.cancel_button);
        this.save_button = new JButton("Save");
        this.save_button.addActionListener(this);
        this.add(this.save_button);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.choose_encoding_format_button)) {
            this.chooseEncodingFormt();
        } else if (event.getSource().equals(this.display_current_audio_format_button)) {
            this.displayCurrentAudioFormat();
        } else if (event.getSource().equals(this.record_button)) {
            this.record();
        } else if (event.getSource().equals(this.stop_recording_button)) {
            this.stopRecording();
        } else if (event.getSource().equals(this.play_recording_button)) {
            this.play();
        } else if (event.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (event.getSource().equals(this.save_button)) {
            this.save();
        }
    }

    private void chooseEncodingFormt() {
        this.audio_format_selector.setVisible(true);
    }

    private void displayCurrentAudioFormat() {
        if (this.last_recorded_audio != null) {
            String data = AudioMethods.getAudioFormatData(this.last_recorded_audio.getFormat());
            JOptionPane.showMessageDialog(null, data, "Current Audio Encoding", 1);
        } else {
            JOptionPane.showMessageDialog(null, "No audio has been stored.", "WARNING", 0);
        }
    }

    private void record() {
        try {
            this.stopRecording();
            this.stopPlayback();
            AudioFormat audio_format = this.audio_format_selector.getAudioFormat(true);
            TargetDataLine target_data_line = AudioMethods.getTargetDataLine(audio_format, null);
            this.record_thread = AudioMethodsRecording.recordByteArrayOutputStream(target_data_line);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not record because:\n" + e.getMessage(), "ERROR", 0);
        }
    }

    private void stopRecording() {
        if (this.record_thread != null) {
            this.record_thread.stopRecording();
            ByteArrayOutputStream audio_buffer = this.record_thread.getRecordedData();
            AudioFormat audio_buffer_format = this.record_thread.getFormatUsedForRecording();
            this.last_recorded_audio = AudioMethods.getInputStream(audio_buffer, audio_buffer_format);
            this.record_thread = null;
        }
    }

    private void play() {
        if (this.last_recorded_audio != null) {
            this.stopRecording();
            this.stopPlayback();
            SourceDataLine source_data_line = AudioMethods.getSourceDataLine(this.last_recorded_audio.getFormat(), null);
            try {
                this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(this.last_recorded_audio, source_data_line);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not play because:\n" + e.getMessage(), "ERROR", 0);
            }
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
            try {
                this.last_recorded_audio.reset();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not reset playback position:\n" + e.getMessage(), "ERROR", 0);
            }
        }
        this.playback_thread = null;
    }

    private void cancel() {
        this.stopRecording();
        this.stopPlayback();
        this.last_recorded_audio = null;
        this.setVisible(false);
    }

    private void save() {
        if (this.last_recorded_audio == null) {
            int end = JOptionPane.showConfirmDialog(null, "No recording has been made.\nDo you wish to make a recording?", "WARNING", 0);
            if (end == 1) {
                this.cancel();
            }
        } else {
            int dialog_result;
            this.stopRecording();
            this.stopPlayback();
            if (this.save_file_chooser == null) {
                this.save_file_chooser = new JFileChooser();
                this.save_file_chooser.setCurrentDirectory(new File("."));
                this.save_file_chooser.setFileFilter(new FileFilterAudio());
            }
            if ((dialog_result = this.save_file_chooser.showSaveDialog(this)) == 0) {
                int overwrite;
                File save_file = this.save_file_chooser.getSelectedFile();
                boolean proceed = true;
                String correct_format_name = (String)this.choose_file_format_combo_box.getSelectedItem();
                AudioFileFormat.Type correct_format = AudioMethods.getAudioFileFormatType(correct_format_name);
                if ((save_file = this.ensureCorrectExtension(save_file, correct_format)).exists() && (overwrite = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                    proceed = false;
                }
                if (proceed) {
                    try {
                        AudioMethods.saveToFile(this.last_recorded_audio, save_file, correct_format);
                        File[] to_add_to_table = new File[]{save_file};
                        this.controller.addRecordingsAction.addRecording(to_add_to_table);
                        this.cancel();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                    }
                }
            }
        }
    }

    private File ensureCorrectExtension(File file_to_verify, AudioFileFormat.Type file_format_type) {
        String correct_extension = "." + file_format_type.getExtension();
        String path = file_to_verify.getAbsolutePath();
        String ext = StringMethods.getExtension(path);
        if (ext == null) {
            path = String.valueOf(path) + correct_extension;
        } else if (!ext.equals(correct_extension)) {
            path = String.valueOf(StringMethods.removeExtension(path)) + correct_extension;
        } else {
            return file_to_verify;
        }
        JOptionPane.showMessageDialog(null, "Incorrect file extension specified.\nChanged from " + ext + " to " + correct_extension + ".", "WARNING", 0);
        return new File(path);
    }
}

