/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.DataModel;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class GlobalWindowChange
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private DataModel fm_;
    private JButton cancel;
    private JButton save;
    private JTextArea inputBox;

    public GlobalWindowChange(DataModel fm) {
        this.fm_ = fm;
        this.setTitle("Globally change window sizes");
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GlobalWindowChange.this.cancel();
            }
        });
        this.inputBox = new JTextArea();
        JLabel boxLabel = new JLabel("Global Window Width");
        this.save = new JButton("save");
        this.save.addActionListener(this);
        this.cancel = new JButton("cancel");
        this.cancel.addActionListener(this);
        this.setLayout(new GridLayout(2, 2, 6, 11));
        this.add(this.inputBox);
        this.add(boxLabel);
        this.add(this.save);
        this.add(this.cancel);
        this.pack();
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void save() {
        try {
            int type = Integer.parseInt(this.inputBox.getText());
            int i = 0;
            while (i < this.fm_.features.length) {
                this.fm_.features[i].setWindow(type);
                ++i;
            }
            this.setVisible(false);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.inputBox.getText()) + " is not an integer", "ERROR", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.cancel)) {
            this.cancel();
        } else if (e.getSource().equals(this.save)) {
            this.save();
        }
    }
}

