/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

public class Statistics {
    public static double getAverage(double[] data) {
        if (data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            ++i;
        }
        return sum / (double)data.length;
    }

    public static double getAverage(int[] data) {
        if (data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += (double)data[i];
            ++i;
        }
        return sum / (double)data.length;
    }

    public static double getStandardDeviation(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double average = Statistics.getAverage(data);
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            double diff = data[i] - average;
            sum += diff * diff;
            ++i;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public static double getStandardDeviation(int[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double average = Statistics.getAverage(data);
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            double diff = (double)data[i] - average;
            sum += diff * diff;
            ++i;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public static boolean isFactorOrMultiple(int x, int y, int[] z) {
        boolean is_factor_or_multiple = false;
        if (y > x) {
            int i = 0;
            while (i < z.length) {
                if (x * z[i] == y) {
                    is_factor_or_multiple = true;
                    i = z.length + 1;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < z.length) {
                if (y * z[i] == x) {
                    is_factor_or_multiple = true;
                    i = z.length + 1;
                }
                ++i;
            }
        }
        return is_factor_or_multiple;
    }

    public static int getIndexOfLargest(double[] values) {
        int max_index = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] > values[max_index]) {
                max_index = i;
            }
            ++i;
        }
        return max_index;
    }

    public static int getIndexOfSmallest(double[] values) {
        int min_index = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] < values[min_index]) {
                min_index = i;
            }
            ++i;
        }
        return min_index;
    }

    public static int getIndexOfLargest(float[] values) {
        int max_index = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] > values[max_index]) {
                max_index = i;
            }
            ++i;
        }
        return max_index;
    }

    public static int getIndexOfLargest(int[] values) {
        int max_index = 0;
        int i = 0;
        while (i < values.length) {
            if (values[i] > values[max_index]) {
                max_index = i;
            }
            ++i;
        }
        return max_index;
    }

    public static double calculateEuclideanDistance(double[] x, double[] y) throws Exception {
        if (x.length != y.length) {
            throw new Exception("The two given arrays have different sizes.");
        }
        double total = 0.0;
        int dim = 0;
        while (dim < x.length) {
            total += Math.pow(x[dim] - y[dim], 2.0);
            ++dim;
        }
        return Math.sqrt(total);
    }

    public static int generateRandomNumber(int max) {
        int random_number = (int)(2.147483647E9 * Math.random());
        return random_number % max;
    }

    public static int[] getRandomOrdering(int number_entries) {
        double[] random_values = new double[number_entries];
        int i = 0;
        while (i < random_values.length) {
            random_values[i] = Math.random();
            ++i;
        }
        int[] scrambled_values = new int[number_entries];
        int i2 = 0;
        while (i2 < scrambled_values.length) {
            int largest_index;
            scrambled_values[i2] = largest_index = Statistics.getIndexOfLargest(random_values);
            random_values[largest_index] = -1.0;
            ++i2;
        }
        return scrambled_values;
    }

    public static double getArraySum(double[] to_sum) {
        double sum = 0.0;
        int i = 0;
        while (i < to_sum.length) {
            sum += to_sum[i];
            ++i;
        }
        return sum;
    }

    public static double[] normalize(double[] to_normalize) {
        double[] normalized = new double[to_normalize.length];
        int i = 0;
        while (i < normalized.length) {
            normalized[i] = to_normalize[i];
            ++i;
        }
        double sum = Statistics.getArraySum(normalized);
        int i2 = 0;
        while (i2 < normalized.length) {
            normalized[i2] = normalized[i2] / sum;
            ++i2;
        }
        return normalized;
    }

    public static double[][] normalize(double[][] to_normalize) {
        int j;
        double[][] normalized = new double[to_normalize.length][];
        int i = 0;
        while (i < normalized.length) {
            normalized[i] = new double[to_normalize[i].length];
            int j2 = 0;
            while (j2 < normalized[i].length) {
                normalized[i][j2] = to_normalize[i][j2];
                ++j2;
            }
            ++i;
        }
        double[] totals = new double[normalized.length];
        int i2 = 0;
        while (i2 < normalized.length) {
            totals[i2] = 0.0;
            j = 0;
            while (j < normalized[i2].length) {
                int n = i2;
                totals[n] = totals[n] + normalized[i2][j];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < normalized.length) {
            j = 0;
            while (j < normalized[i2].length) {
                normalized[i2][j] = normalized[i2][j] / totals[i2];
                ++j;
            }
            ++i2;
        }
        return normalized;
    }

    public static int pow(int a, int b) {
        int result = a;
        int i = 1;
        while (i < b) {
            result *= a;
            ++i;
        }
        return result;
    }

    public static double logBaseN(double x, double n) {
        return Math.log10(x) / Math.log10(n);
    }

    public static int ensureIsPowerOfN(int x, int n) {
        double log_value = Statistics.logBaseN(x, n);
        int log_int = (int)log_value;
        int valid_size = Statistics.pow(n, log_int);
        if (valid_size != x) {
            valid_size = Statistics.pow(n, log_int + 1);
        }
        return valid_size;
    }
}

