/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class PlotDisplay
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private double x_tic_interval;
    private double y_tic_interval;
    private JTextField x_min_tf;
    private JTextField x_max_tf;
    private JTextField y_min_tf;
    private JTextField y_max_tf;
    private JTextField x_tic_interval_tf;
    private JTextField y_tic_interval_tf;
    private Canvas[] canvases;
    private double[][] data_points;
    private double[][] data_x_coordinates;

    public PlotDisplay(double[][] data_points_to_plot, double[][] data_x_coordinates_to_plot, boolean plot_on_one_graph, String plot_name, boolean quit_on_exit) throws Exception {
        int j;
        this.data_points = data_points_to_plot;
        this.data_x_coordinates = data_x_coordinates_to_plot;
        if (this.data_points == null) {
            throw new Exception("No data points were provided to plot.");
        }
        if (this.data_points.length > 5) {
            throw new Exception("More than five data sets specified.");
        }
        int i = 0;
        while (i < this.data_points.length) {
            if (this.data_points[i] == null) {
                throw new Exception("Data set " + i + " is empty.");
            }
            ++i;
        }
        if (this.data_x_coordinates != null) {
            if (this.data_points.length != this.data_x_coordinates.length) {
                throw new Exception("There are a different number of data sets\nand data set labels.");
            }
            i = 0;
            while (i < this.data_points.length) {
                if (this.data_points[i].length != this.data_x_coordinates[i].length) {
                    throw new Exception("Data set " + i + " has a different number\n" + "of data points and x-coodinate labels.");
                }
                ++i;
            }
        }
        if (this.data_x_coordinates == null) {
            this.data_x_coordinates = new double[this.data_points.length][];
            i = 0;
            while (i < this.data_points.length) {
                this.data_x_coordinates[i] = new double[this.data_points[i].length];
                j = 0;
                while (j < this.data_points[i].length) {
                    this.data_x_coordinates[i][j] = j;
                    ++j;
                }
                ++i;
            }
        }
        this.x_min = this.data_x_coordinates[0][0];
        this.x_max = this.data_x_coordinates[0][0];
        this.y_min = this.data_points[0][0];
        this.y_max = this.data_points[0][0];
        i = 0;
        while (i < this.data_points.length) {
            j = 0;
            while (j < this.data_points[i].length) {
                if (this.data_points[i][j] < this.y_min) {
                    this.y_min = this.data_points[i][j];
                }
                if (this.data_points[i][j] > this.y_max) {
                    this.y_max = this.data_points[i][j];
                }
                if (this.data_x_coordinates[i][j] < this.x_min) {
                    this.x_min = this.data_x_coordinates[i][j];
                }
                if (this.data_x_coordinates[i][j] > this.x_max) {
                    this.x_max = this.data_x_coordinates[i][j];
                }
                ++j;
            }
            ++i;
        }
        if (this.y_min < 0.0) {
            this.y_min -= Math.abs(this.y_min * 0.05);
        }
        this.y_max += Math.abs(this.y_max * 0.05);
        this.x_tic_interval = 10.0;
        this.y_tic_interval = 0.1;
        this.x_min_tf = new JTextField("" + this.x_min, 7);
        this.x_max_tf = new JTextField("" + this.x_max, 7);
        this.y_min_tf = new JTextField("" + this.y_min, 7);
        this.y_max_tf = new JTextField("" + this.y_max, 7);
        this.x_tic_interval_tf = new JTextField("" + this.x_tic_interval, 7);
        this.y_tic_interval_tf = new JTextField("" + this.y_tic_interval, 7);
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        JPanel control_panel = new JPanel();
        control_panel.setLayout(new GridLayout(2, 4));
        control_panel.setBorder(new EtchedBorder());
        control_panel.setBackground(this.getContentPane().getBackground());
        JButton replot_button = new JButton("Replot");
        replot_button.addActionListener(this);
        JPanel pan0 = new JPanel();
        pan0.add(new JLabel("Minimum X"));
        pan0.add(this.x_min_tf);
        pan0.setBackground(this.getContentPane().getBackground());
        JPanel pan1 = new JPanel();
        pan1.add(new JLabel("Maximum X"));
        pan1.add(this.x_max_tf);
        pan1.setBackground(this.getContentPane().getBackground());
        JPanel pan2 = new JPanel();
        pan2.add(new JLabel("Minimum Y"));
        pan2.add(this.y_min_tf);
        pan2.setBackground(this.getContentPane().getBackground());
        JPanel pan3 = new JPanel();
        pan3.add(new JLabel("Maximum Y"));
        pan3.add(this.y_max_tf);
        pan3.setBackground(this.getContentPane().getBackground());
        JPanel pan4 = new JPanel();
        pan4.add(new JLabel("X Tic Interval"));
        pan4.add(this.x_tic_interval_tf);
        pan4.setBackground(this.getContentPane().getBackground());
        JPanel pan5 = new JPanel();
        pan5.add(new JLabel("Y Tic Interval"));
        pan5.add(this.y_tic_interval_tf);
        pan5.setBackground(this.getContentPane().getBackground());
        control_panel.add(pan0);
        control_panel.add(pan1);
        control_panel.add(pan2);
        control_panel.add(pan3);
        control_panel.add(pan4);
        control_panel.add(pan5);
        control_panel.add(new JLabel(""));
        control_panel.add(replot_button);
        JPanel canvas_panel = new JPanel();
        canvas_panel.setLayout(new GridLayout(0, 1));
        if (!plot_on_one_graph) {
            this.canvases = new Canvas[this.data_points.length];
            int i2 = 0;
            while (i2 < this.data_points.length) {
                this.canvases[i2] = new PlotCanvas(i2, false);
                if (i2 % 2 == 0) {
                    this.canvases[i2].setBackground(Color.WHITE);
                } else {
                    this.canvases[i2].setBackground(Color.LIGHT_GRAY);
                }
                canvas_panel.add(this.canvases[i2]);
                ++i2;
            }
        } else {
            this.canvases = new Canvas[1];
            this.canvases[0] = new PlotCanvas(0, true);
            this.canvases[0].setBackground(Color.WHITE);
            canvas_panel.add(this.canvases[0]);
        }
        this.getContentPane().add((Component)control_panel, "South");
        this.getContentPane().add((Component)canvas_panel, "Center");
        if (quit_on_exit) {
            this.setDefaultCloseOperation(3);
        } else {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PlotDisplay.this.end();
                }
            });
        }
        int frame_width = 800;
        int frame_height = 500;
        this.setBounds(0, 0, frame_width, frame_height);
        if (plot_name == null) {
            plot_name = new String("Data Plot");
        }
        this.setTitle(plot_name);
        this.setVisible(true);
        int i3 = 0;
        while (i3 < this.canvases.length) {
            this.canvases[i3].repaint();
            ++i3;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            this.x_min = Double.parseDouble(this.x_min_tf.getText());
            this.x_max = Double.parseDouble(this.x_max_tf.getText());
            this.y_min = Double.parseDouble(this.y_min_tf.getText());
            this.y_max = Double.parseDouble(this.y_max_tf.getText());
            this.x_tic_interval = Double.parseDouble(this.x_tic_interval_tf.getText());
            this.y_tic_interval = Double.parseDouble(this.y_tic_interval_tf.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Invalid text option: " + e.getMessage(), "ERROR", 0);
        }
        int i = 0;
        while (i < this.canvases.length) {
            this.canvases[i].repaint();
            ++i;
        }
    }

    private void end() {
        this.setVisible(false);
        this.data_points = null;
        this.data_x_coordinates = null;
        this.dispose();
        this.canvases = null;
        System.gc();
    }

    private class PlotCanvas
    extends Canvas {
        static final long serialVersionUID = 1L;
        private double x_scale;
        private double y_scale;
        private int data_set_index;
        private double x_tic_length;
        private double y_tic_length;
        private boolean plot_on_one_graph;

        public PlotCanvas(int data_set_index, boolean plot_on_one_graph) {
            this.data_set_index = data_set_index;
            this.plot_on_one_graph = plot_on_one_graph;
        }

        @Override
        public void paint(Graphics g) {
            int width = PlotDisplay.this.canvases[this.data_set_index].getWidth();
            int height = PlotDisplay.this.canvases[this.data_set_index].getHeight();
            this.x_scale = (double)width / (PlotDisplay.this.x_max - PlotDisplay.this.x_min);
            this.y_scale = (double)height / (PlotDisplay.this.y_max - PlotDisplay.this.y_min);
            this.x_tic_length = (PlotDisplay.this.y_max - PlotDisplay.this.y_min) / 35.0;
            this.y_tic_length = (PlotDisplay.this.x_max - PlotDisplay.this.x_min) / 100.0;
            g.translate((int)((0.0 - PlotDisplay.this.x_min) * this.x_scale), (int)((0.0 - PlotDisplay.this.y_min) * this.y_scale));
            this.drawAxes(g);
            g.setColor(Color.BLACK);
            if (!this.plot_on_one_graph) {
                int old_x = this.scaleX(PlotDisplay.this.data_x_coordinates[this.data_set_index][0]);
                int old_y = this.scaleY(PlotDisplay.this.data_points[this.data_set_index][0]);
                int i = 0;
                while (i < PlotDisplay.this.data_points[this.data_set_index].length) {
                    int new_x = this.scaleX(PlotDisplay.this.data_x_coordinates[this.data_set_index][i]);
                    int new_y = this.scaleY(PlotDisplay.this.data_points[this.data_set_index][i]);
                    g.drawLine(old_x, old_y, new_x, new_y);
                    old_x = new_x;
                    old_y = new_y;
                    ++i;
                }
            } else {
                int j = 0;
                while (j < PlotDisplay.this.data_points.length) {
                    int old_x = this.scaleX(PlotDisplay.this.data_x_coordinates[j][0]);
                    int old_y = this.scaleY(PlotDisplay.this.data_points[j][0]);
                    int i = 0;
                    while (i < PlotDisplay.this.data_points[j].length) {
                        int new_x = this.scaleX(PlotDisplay.this.data_x_coordinates[j][i]);
                        int new_y = this.scaleY(PlotDisplay.this.data_points[j][i]);
                        g.drawLine(old_x, old_y, new_x, new_y);
                        old_x = new_x;
                        old_y = new_y;
                        ++i;
                    }
                    ++j;
                }
            }
        }

        private void drawAxes(Graphics g) {
            g.setColor(Color.RED);
            String x_max_string = "" + PlotDisplay.this.x_max;
            char[] x_max_chars = x_max_string.toCharArray();
            FontMetrics font_metrics = g.getFontMetrics();
            Rectangle2D r2d = font_metrics.getStringBounds(x_max_chars, 0, x_max_chars.length, g);
            int label_width = (int)r2d.getWidth();
            int label_height = (int)r2d.getHeight();
            if (PlotDisplay.this.x_min <= 0.0 && PlotDisplay.this.x_max >= 0.0) {
                g.drawLine(this.scaleX(0.0), this.scaleY(PlotDisplay.this.y_min), this.scaleX(0.0), this.scaleY(PlotDisplay.this.y_max));
                g.drawString("" + PlotDisplay.this.y_min, this.scaleX(this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_min));
                g.drawString("" + PlotDisplay.this.y_max, this.scaleX(this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_max) + label_height);
            } else if (PlotDisplay.this.x_min > 0.0) {
                g.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min), this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_max));
                g.drawString("" + PlotDisplay.this.y_min, this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_min));
                g.drawString("" + PlotDisplay.this.y_max, this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_max) + label_height);
            } else if (PlotDisplay.this.x_max < 0.0) {
                g.drawLine(this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min), this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_max));
                g.drawString("" + PlotDisplay.this.y_min, this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0) - 20, this.scaleY(PlotDisplay.this.y_min));
                g.drawString("" + PlotDisplay.this.y_max, this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0) - 20, this.scaleY(PlotDisplay.this.y_max) + label_height);
            }
            if (PlotDisplay.this.y_min <= 0.0 && PlotDisplay.this.y_max >= 0.0) {
                g.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(0.0), this.scaleX(PlotDisplay.this.x_max), this.scaleY(0.0));
                g.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(this.x_tic_length / 2.0) - 2);
                g.drawString(x_max_string, this.scaleX(PlotDisplay.this.x_max) - label_width, this.scaleY(this.x_tic_length / 2.0) - 2);
            } else if (PlotDisplay.this.y_min > 0.0) {
                g.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min) - 1, this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min) - 1);
                g.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
                g.drawString(x_max_string, this.scaleX(PlotDisplay.this.x_max) - label_width, this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
            } else if (PlotDisplay.this.y_max < 0.0) {
                g.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min) - 1, this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min) - 1);
                g.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
                g.drawString(x_max_string, this.scaleX(PlotDisplay.this.x_max) - label_width, this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
            }
            this.drawXTics(g);
            this.drawYTics(g);
        }

        private void drawXTics(Graphics g) {
            int bottom_end;
            int top_end;
            if (PlotDisplay.this.y_min <= 0.0 && PlotDisplay.this.y_max >= 0.0) {
                top_end = this.scaleY(this.x_tic_length / 2.0);
                bottom_end = this.scaleY(-this.x_tic_length / 2.0);
            } else {
                top_end = this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0);
                bottom_end = this.scaleY(PlotDisplay.this.y_min);
            }
            double x_doub = 0.0;
            int x = 0;
            while (x_doub < PlotDisplay.this.x_max) {
                x = this.scaleX(x_doub);
                g.drawLine(x, top_end, x, bottom_end);
                x_doub += PlotDisplay.this.x_tic_interval;
            }
            x_doub = 0.0;
            while (x_doub > PlotDisplay.this.x_min) {
                x = this.scaleX(x_doub);
                g.drawLine(x, top_end, x, bottom_end);
                x_doub -= PlotDisplay.this.x_tic_interval;
            }
        }

        private void drawYTics(Graphics g) {
            int left_end = 0;
            int right_end = 0;
            if (PlotDisplay.this.x_min <= 0.0 && PlotDisplay.this.x_max >= 0.0) {
                left_end = this.scaleX(-this.y_tic_length / 2.0);
                right_end = this.scaleX(this.y_tic_length / 2.0);
            } else if (PlotDisplay.this.x_min >= 0.0) {
                left_end = this.scaleX(PlotDisplay.this.x_min);
                right_end = this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0);
            } else if (PlotDisplay.this.x_max <= 0.0) {
                left_end = this.scaleX(PlotDisplay.this.x_max);
                right_end = this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0);
            }
            double y_doub = 0.0;
            int y = 0;
            while (y_doub < PlotDisplay.this.y_max) {
                y = this.scaleY(y_doub);
                g.drawLine(right_end, y, left_end, y);
                y_doub += PlotDisplay.this.y_tic_interval;
            }
            y_doub = 0.0;
            while (y_doub > PlotDisplay.this.y_min) {
                y = this.scaleY(y_doub);
                g.drawLine(right_end, y, left_end, y);
                y_doub -= PlotDisplay.this.y_tic_interval;
            }
        }

        private int scaleX(double x) {
            return (int)(x * this.x_scale);
        }

        private int scaleY(double y) {
            double y_doub = PlotDisplay.this.y_max + PlotDisplay.this.y_min - y;
            return (int)(y_doub * this.y_scale);
        }
    }
}

