/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.AggregatorFrame;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.EditFeatures;
import jAudioFeatureExtractor.ExtractionThread;
import jAudioFeatureExtractor.GeneralTools.FeatureDisplay;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.SortingTableModelDecorator;
import jAudioFeatureExtractor.actions.MultipleToggleAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FeatureSelectorPanel
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 1L;
    public OuterFrame outer_frame;
    private MultipleToggleAction multipleToggleAction;
    private JPanel features_panel;
    private JScrollPane features_scroll_pane;
    private JTable features_table;
    private SortingTableModelDecorator decorator;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private JButton extract_features_button;
    private JButton set_aggregators_button;
    private JFileChooser save_file_chooser;
    private AggregatorFrame aggregator_editor = null;
    private EditFeatures ef_ = null;
    private Controller controller;

    public FeatureSelectorPanel(OuterFrame outer_frame, Controller c) {
        this.outer_frame = outer_frame;
        this.controller = c;
        this.save_file_chooser = null;
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        this.setUpFeatureTable();
        this.add((Component)new JLabel("FEATURES:"), "North");
        JPanel control_panel = new JPanel(new GridLayout(4, 2, horizontal_gap, vertical_gap));
        this.save_window_features_check_box = new JCheckBox("Save Features For Each Window", false);
        this.save_window_features_check_box.setBackground(blue);
        this.save_window_features_check_box.addActionListener(this);
        control_panel.add(this.save_window_features_check_box);
        this.save_overall_file_featurese_check_box = new JCheckBox("Save For Overall Recordings", true);
        this.save_overall_file_featurese_check_box.setBackground(blue);
        this.save_overall_file_featurese_check_box.addActionListener(this);
        control_panel.add(this.save_overall_file_featurese_check_box);
        control_panel.add(new JLabel("Window Size (samples):"));
        this.window_length_text_field = new JTextArea("512", 1, 20);
        control_panel.add(this.window_length_text_field);
        control_panel.add(new JLabel("Window Overlap (fraction):"));
        this.window_overlap_fraction_text_field = new JTextArea("0.0", 1, 20);
        control_panel.add(this.window_overlap_fraction_text_field);
        this.set_aggregators_button = new JButton("Alter Aggregators");
        this.set_aggregators_button.addActionListener(this);
        control_panel.add(this.set_aggregators_button);
        this.extract_features_button = new JButton("Extract Features");
        this.extract_features_button.addActionListener(this);
        control_panel.add(this.extract_features_button);
        control_panel.setBackground(blue);
        this.add((Component)control_panel, "South");
        this.addTableMouseListener();
        this.controller.saveAction.setObjectReferences(this.window_length_text_field, this.window_overlap_fraction_text_field, this.save_window_features_check_box, this.save_overall_file_featurese_check_box);
        this.controller.loadAction.setObjectReferences(this.window_length_text_field, this.window_overlap_fraction_text_field, this.save_window_features_check_box, this.save_overall_file_featurese_check_box);
        this.controller.outputTypeAction.setTarget(outer_frame.ace, outer_frame.arff, this.save_window_features_check_box, this.save_window_features_check_box);
        this.controller.addBatchAction.setSettings(this.save_window_features_check_box, this.save_overall_file_featurese_check_box, this.window_length_text_field, this.window_overlap_fraction_text_field);
        this.controller.viewBatchAction.setFeatureFields(this.save_window_features_check_box, this.save_overall_file_featurese_check_box, this.window_length_text_field, this.window_overlap_fraction_text_field);
        this.controller.dm_.aggregators = new Aggregator[]{(Aggregator)this.controller.dm_.aggregatorMap.get("Standard Deviation").clone(), (Aggregator)this.controller.dm_.aggregatorMap.get("Mean").clone()};
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.extract_features_button)) {
            this.extractFeatures();
        } else if (event.getSource().equals(this.save_overall_file_featurese_check_box)) {
            JCheckBox tmp = (JCheckBox)event.getSource();
            if (tmp.isSelected() && this.save_window_features_check_box.isSelected() && this.controller.outputTypeAction.getSelected() == 1) {
                JOptionPane.showMessageDialog(null, "Weka format only supports one type of output - either output per file or output per window.", "ERROR", 0);
                tmp.setSelected(false);
            }
        } else if (event.getSource().equals(this.save_window_features_check_box)) {
            JCheckBox tmp = (JCheckBox)event.getSource();
            if (tmp.isSelected() && this.save_overall_file_featurese_check_box.isSelected() && this.controller.outputTypeAction.getSelected() == 1) {
                JOptionPane.showMessageDialog(null, "Weka format only supports one type of output - either output per file or output per window.", "ERROR", 0);
                tmp.setSelected(false);
            }
        } else if (event.getSource().equals(this.set_aggregators_button)) {
            this.launchAggEditTable();
        }
    }

    private void extractFeatures() {
        block6: {
            try {
                String message;
                int convert;
                int pow_2_size;
                boolean save_features_for_each_window = this.save_window_features_check_box.isSelected();
                boolean save_overall_recording_features = this.save_overall_file_featurese_check_box.isSelected();
                String feature_values_save_path = this.outer_frame.recording_selector_panel.values_save_path_text_field.getText();
                String feature_definitions_save_path = this.outer_frame.recording_selector_panel.definitions_save_path_text_field.getText();
                int window_size = Integer.parseInt(this.window_length_text_field.getText());
                double window_overlap = Double.parseDouble(this.window_overlap_fraction_text_field.getText());
                boolean normalise = this.controller.normalise.isSelected();
                double sampling_rate = this.controller.samplingRateAction.getSamplingRate();
                int outputType = this.controller.outputTypeAction.getSelected();
                RecordingInfo[] recordings = this.controller.dm_.recordingInfo;
                if (recordings == null) {
                    throw new Exception("No recordings available to extract features from.");
                }
                if (window_size >= 0 && window_size != (pow_2_size = Statistics.ensureIsPowerOfN(window_size, 2)) && (convert = JOptionPane.showConfirmDialog(null, message = "Given window size is " + window_size + ", which is not a power\n" + "of 2. Would you like to increase this to the\n" + "next highest power of 2 (" + pow_2_size + ")?", "WARNING", 0)) == 0) {
                    this.window_length_text_field.setText(String.valueOf(pow_2_size));
                    window_size = Integer.parseInt(this.window_length_text_field.getText());
                }
                int i = 0;
                while (i < this.controller.dm_.defaults.length) {
                    this.controller.dm_.defaults[i] = (Boolean)this.controller.fstm_.getValueAt(i, 0);
                    ++i;
                }
                this.controller.extractionThread = new ExtractionThread(this.controller, this.outer_frame);
                this.controller.extractionThread.setup(save_overall_recording_features, save_features_for_each_window, feature_values_save_path, feature_definitions_save_path, window_size, window_overlap);
                this.controller.extractionThread.start();
            }
            catch (Throwable t) {
                if (t.toString().equals("java.lang.OutOfMemoryError")) {
                    JOptionPane.showMessageDialog(null, "The Java Runtime ran out of memory. Please rerun this program\nwith a higher amount of memory assigned to the Java Runtime heap.", "ERROR", 0);
                }
                if (!(t instanceof Exception)) break block6;
                Exception e = (Exception)t;
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        }
    }

    private void setUpFeatureTable() {
        this.controller.fstm_.fillTable(this.controller.dm_.featureDefinitions, this.controller.dm_.defaults, this.controller.dm_.is_primary);
        this.decorator = new SortingTableModelDecorator(this.controller.fstm_);
        this.features_table = new JTable(this.decorator);
        this.multipleToggleAction = new MultipleToggleAction(this.features_table);
        String key = "MultipleToggleAction";
        this.features_table.getInputMap().put(KeyStroke.getKeyStroke(' '), key);
        this.features_table.getActionMap().put(key, this.multipleToggleAction);
        int[] width = new int[3];
        width[0] = this.decorator.getRealPrefferedWidth(this.features_table, 0);
        width[1] = this.decorator.getRealPrefferedWidth(this.features_table, 1);
        width[1] = width[1] - 100;
        width[2] = this.decorator.getRealPrefferedWidth(this.features_table, 2);
        int i = 0;
        while (i < width.length) {
            this.features_table.getColumnModel().getColumn(i).setPreferredWidth(width[i]);
            ++i;
        }
        JTableHeader header = this.features_table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    TableColumnModel tcm = FeatureSelectorPanel.this.features_table.getColumnModel();
                    int column = FeatureSelectorPanel.this.features_table.convertColumnIndexToModel(tcm.getColumnIndexAtX(e.getX()));
                    FeatureSelectorPanel.this.decorator.sort(column);
                } else {
                    FeatureSelectorPanel.this.decorator.resetIndeci();
                }
            }
        });
        this.features_scroll_pane = new JScrollPane(this.features_table);
        this.features_panel = new JPanel(new GridLayout(1, 1));
        this.features_panel.add(this.features_scroll_pane);
        this.add((Component)this.features_panel, "Center");
        this.controller.fstm_.fireTableDataChanged();
        TableColumn tableColumn = this.features_table.getColumn(this.features_table.getColumnName(1));
        tableColumn.setCellRenderer(new FeatureDisplay());
        this.features_table.removeColumn(this.features_table.getColumn(this.features_table.getColumnName(3)));
        this.repaint();
        this.outer_frame.repaint();
    }

    public void addTableMouseListener() {
        this.features_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    int[] row_clicked = new int[]{FeatureSelectorPanel.this.features_table.rowAtPoint(event.getPoint())};
                    FeatureSelectorPanel.this.editDialog(((FeatureSelectorPanel)FeatureSelectorPanel.this).controller.dm_.features[row_clicked[0]]);
                }
            }
        });
    }

    private void editDialog(FeatureExtractor fe) {
        this.ef_ = new EditFeatures(this, fe);
        this.ef_.setVisible(true);
    }

    private void launchAggEditTable() {
        this.aggregator_editor = new AggregatorFrame(this.controller);
        this.aggregator_editor.setVisible(true);
    }
}

