/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Aggregators.AggregatorContainer;
import jAudioFeatureExtractor.Aggregators.AreaMoments;
import jAudioFeatureExtractor.Aggregators.StandardDeviation;
import jAudioFeatureExtractor.AudioFeatures.Derivative;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.Mean;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;
import jAudioFeatureExtractor.Cancel;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.ModelListener;
import jAudioFeatureExtractor.Updater;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.FeatureProcessor;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class DataModel {
    public ModelListener ml_;
    public Cancel cancel_;
    public boolean[] defaults;
    public FeatureExtractor[] features;
    public HashMap<String, Aggregator> aggregatorMap;
    public Aggregator[] aggregators;
    public AggregatorContainer container = null;
    public boolean[] is_primary;
    public FeatureDefinition[] featureDefinitions;
    public RecordingInfo[] recordingInfo;
    public AudioMethodsPlayback.PlayThread playback_thread;
    Updater updater = null;
    public OutputStream featureKey = null;
    public OutputStream featureValue = null;

    public DataModel(String featureXMLLocation, ModelListener ml) {
        this.ml_ = ml;
        this.cancel_ = new Cancel();
        LinkedList<MetaFeatureFactory> metaExtractors = new LinkedList<MetaFeatureFactory>();
        metaExtractors.add(new Derivative());
        metaExtractors.add(new Mean());
        metaExtractors.add(new jAudioFeatureExtractor.AudioFeatures.StandardDeviation());
        metaExtractors.add(new Derivative(new Mean()));
        metaExtractors.add(new Derivative(new jAudioFeatureExtractor.AudioFeatures.StandardDeviation()));
        LinkedList extractors = new LinkedList();
        LinkedList def = new LinkedList();
        this.aggregatorMap = new HashMap();
        try {
            Object[] lists = (Object[])XMLDocumentParser.parseXMLDocument(featureXMLLocation, "feature_list");
            extractors = (LinkedList)lists[0];
            def = (LinkedList)lists[1];
            Aggregator[] aggArray = ((LinkedList)lists[2]).toArray(new Aggregator[0]);
            int i = 0;
            while (i < aggArray.length) {
                this.aggregatorMap.put(aggArray[i].getAggregatorDefinition().name, aggArray[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.populateMetaFeatures(metaExtractors, extractors, def);
    }

    void populateMetaFeatures(LinkedList<MetaFeatureFactory> listMFF, LinkedList<FeatureExtractor> listFE, LinkedList<Boolean> def) {
        LinkedList<Boolean> tmpDefaults = new LinkedList<Boolean>();
        LinkedList<FeatureExtractor> tmpFeatures = new LinkedList<FeatureExtractor>();
        LinkedList<Boolean> isPrimaryList = new LinkedList<Boolean>();
        Iterator lFE = listFE.iterator();
        Iterator lD = def.iterator();
        while (lFE.hasNext()) {
            FeatureExtractor tmpF = (FeatureExtractor)lFE.next();
            Boolean tmpB = (Boolean)lD.next();
            tmpFeatures.add(tmpF);
            tmpDefaults.add(tmpB);
            isPrimaryList.add(new Boolean(true));
            tmpF.setParent(this);
            if (tmpF.getFeatureDefinition().dimensions == 0) continue;
            for (MetaFeatureFactory tmpMFF : listMFF) {
                MetaFeatureFactory tmp = tmpMFF.defineFeature((FeatureExtractor)tmpF.clone());
                ((FeatureExtractor)tmp).setParent(this);
                tmpFeatures.add(tmp);
                tmpDefaults.add(new Boolean(false));
                isPrimaryList.add(new Boolean(false));
            }
        }
        this.features = tmpFeatures.toArray(new FeatureExtractor[1]);
        Boolean[] defaults_temp = tmpDefaults.toArray(new Boolean[1]);
        Boolean[] is_primary_temp = isPrimaryList.toArray(new Boolean[0]);
        this.defaults = new boolean[defaults_temp.length];
        this.is_primary = new boolean[defaults_temp.length];
        int i = 0;
        while (i < this.defaults.length) {
            this.defaults[i] = defaults_temp[i];
            this.is_primary[i] = is_primary_temp[i];
            ++i;
        }
        this.featureDefinitions = new FeatureDefinition[this.defaults.length];
        i = 0;
        while (i < this.featureDefinitions.length) {
            this.featureDefinitions[i] = this.features[i].getFeatureDefinition();
            ++i;
        }
    }

    public void updateTable() {
        if (this.ml_ != null) {
            this.ml_.updateTable();
        }
    }

    public void extract(int windowSize, double windowOverlap, double samplingRate, boolean normalise, boolean perWindowStats, boolean overallStats, RecordingInfo[] info, int arff) throws Exception {
        boolean save_features_for_each_window = perWindowStats;
        boolean save_overall_recording_features = overallStats;
        int window_size = windowSize;
        double window_overlap = windowOverlap;
        double sampling_rate = samplingRate;
        int outputType = arff;
        RecordingInfo[] recordings = info;
        if (recordings == null) {
            throw new Exception("No recordings available to extract features from.");
        }
        if (this.updater != null) {
            this.updater.setNumberOfFiles(recordings.length);
        }
        this.container = new AggregatorContainer();
        if (this.aggregators == null || this.aggregators.length == 0) {
            this.aggregators = new Aggregator[3];
            this.aggregators[0] = new jAudioFeatureExtractor.Aggregators.Mean();
            this.aggregators[1] = new StandardDeviation();
            this.aggregators[2] = new AreaMoments();
            this.aggregators[2].setParameters(new String[]{"Area Method of Moments of MFCCs"}, new String[]{""});
        }
        this.container.add(this.aggregators);
        FeatureProcessor processor = new FeatureProcessor(window_size, window_overlap, sampling_rate, normalise, this.features, this.defaults, save_features_for_each_window, save_overall_recording_features, this.featureValue, this.featureKey, outputType, this.cancel_, this.container);
        int i = 0;
        while (i < recordings.length) {
            File load_file = new File(recordings[i].file_path);
            if (this.updater != null) {
                this.updater.announceUpdate(i, 0);
            }
            processor.extractFeatures(load_file, this.updater);
            ++i;
        }
        processor.finalize();
    }

    public void setUpdater(Updater u) {
        this.updater = u;
    }

    public void validateFile(String definitions, String values) throws Exception {
        File feature_values_save_file = new File(values);
        File feature_definitions_save_file = new File(definitions);
        if (feature_values_save_file.exists() && !feature_values_save_file.canWrite()) {
            throw new Exception("Cannot write to " + values + ".");
        }
        if (feature_definitions_save_file.exists() && !feature_definitions_save_file.canWrite()) {
            throw new Exception("Cannot write to " + definitions + ".");
        }
    }
}

